<?php include_once("../lib/control.seguridad.php"); ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">   
  <!-- JQUERY UI -->  
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />  
  
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />  
  <style>
	  #example{
		  font-size:10px;
	  }
	  #example2{
		  font-size:10px;
	  }	  
	  #example3{
		  font-size:10px;
	  }
	  .card-title{
		  font-size:14px;
	  }
	  h5{
		  font-size:16px;		  
	  }
   .dataTables_wrapper { font-size: 10px }	 	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Marcajes Reloj Control</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">			
				<div class="form-row">
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha Inicio</div>
						</div>
						<input type="text" class="form-control" id="txtFecha_inicio" name="txtFecha_inicio" value="<?php echo date("Y-m-d") ?>" readonly>
					  </div>
					</div>	
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha T&eacute;rmino</div>
						</div>
						<input type="text" class="form-control" id="txtFecha_termino" name="txtFecha_termino" value="<?php echo date("Y-m-d") ?>" readonly>
					  </div>
					</div>	
					<div class="col-md-2">
						<button type='button' class='btn btn-info btn-sm' id='btnEnviar' name='btnEnviar'>Buscar Marcajes</button>
					</div>						
					<div class="col-md-3">
						<button type="button" class="btn btn-info btn-sm" id="btnBuscar">Buscar Trabajador</button>
					</div>						
				</div>	
				<div class="form-row">	
					<div class="col-md-6">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Rut (ej: 17.246.567-7) </div>
						</div>
						<input type="text" class="form-control" id="txtRut" name="txtRut" >
					  </div>
					</div>
					<div class="col-md-6">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Nombre </div>
						</div>
						<input type="text" class="form-control" id="txtNombre" name="txtNombre" readonly >
					  </div>
					</div>													
				</div>								
            </div>
            <!-- /.card-header -->
            <div class="card-body">
				<div class="row">
					<div class="col-md-6">				
						<div class="card">
							<div class="card-header">
								<h3 class="card-title">Marcajes Reloj Control</h3>
							</div>
							<div class="card-body">
							  <table id="example" class="table table-bordered table-striped">
								<thead>
								<tr>	
								  <th>FECHA</th>	
								  <th>HORA</th>								
								  <th>DEPARTAMENTO</th>	
								  <th>SUCURSAL</th>					  
								  <th>Mov.</th>					  
								</tr> 
								</thead>
							  </table>								
							</div>
						</div>									
					</div>
					<div class="col-md-6">					
						<div class="card">
							<div class="card-header">
								<h3 class="card-title">Marcajes Sincronizados</h3>
							</div>
							<div class="card-body">	
							  <table id="example2" class="table table-bordered table-striped">
								<thead>
								<tr>	
								  <th>FECHA</th>	
								  <th>HORA</th>								
								  <th>DEPARTAMENTO</th>	
								  <th>SUCURSAL</th>					  
								  <th>Mov.</th>	
								  <th></th>									  
								</tr> 
								</thead>
							  </table>								
							</div>
						</div>														
					</div>					
				</div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div class="modal fade bd-example-modal-xl" id="modal-buscar" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel" aria-hidden="true">
	  <div class="modal-dialog modal-xl">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">LISTADO DE TRABAJADORES</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body">
			 <div class="row">
				<div class="col-md-4">
				  <div class="form-group  input-group-sm">
					<input type="text" class="form-control control-text" id="txtCriterio">
					<small class="form-text text-muted">Ingrese criterio de b&uacute;sqeda (Rut / Nombre / Apellido).</small>
				  </div>				
				</div>
				<div class="col-md-4">
				  <div class="form-group">
                     <button type='button' class='btn btn-info btn-sm' id='btnFiltro' name='btnFiltro'>APLICAR FILTRO</button>
				  </div>				
				</div>				
			 </div>		  
			 <div class="row">
				<div class="col-md-12">
				  <table id="example3" class="table table-bordered table-striped">
					<thead>
					<tr>	
					  <th>RUT</th>					
					  <th>NOMBRE</th>
					  <th>APELLIDO</th>					  
					  <th></th>				  
					</tr>
					</thead>			
				  </table>					
				</div>
			 </div>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  
	
	<div class="modal fade" id="modal-editar-marcaje" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel" aria-hidden="true">
	  <div class="modal-dialog">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">MARCAJE</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body">	
			  <div class="input-group mb-2 input-group-sm">
				<div class="input-group-prepend">
				  <div class="input-group-text">Fecha</div>
				</div>
				<input type="text" class="form-control control-text" id="txtFecha_marcaje" readonly>
			  </div>
			  <div class="input-group mb-2 input-group-sm">
				<div class="input-group-prepend">
				  <div class="input-group-text">Hora</div>
				</div>
				<input type="text" class="form-control control-text" id="txtHora_marcaje" readonly>
			  </div>			  
			  
			  <div class="input-group mb-2 input-group-sm">
				<div class="input-group-prepend">
				  <div class="input-group-text">Tipo Marcaje</div>
				</div>
				<select class="form-control" id="txtTipo_marcaje">
				</select>
			  </div>			  
		  </div>
		  <div class="modal-footer">
		    <button type="button" class="btn btn-info btn-sm" id="btnEditarMarcaje">Aceptar</button>
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  	
	
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
  <!-- JQUERY UI --> 
<script src="../plugins/jQueryUI/jquery-ui.js"></script> 

<script src="../plugins/toastr/toastr.js"></script>

<script>
  $(function () { 
  
    $(document).bind("contextmenu",function(e){
      return false;
    });	   
	
	combo();
	function combo(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/tipomarcaje",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtTipo_marcaje').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
			}
		});				
	}	
  
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 })  
	 
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      }	  
    });
	
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      }	  
    });	
	 
    $('#example3').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      }	  
    });
	
	$("#btnEnviar").click(function(){
		if( $("#txtRut").val() == null || $("#txtRut").val().length == 0 || /^\s+$/.test($("#txtRut").val()) ){
			toastr.warning("Debe Seleccionar Trabajador", "POWERTIME");
			return false;
		}else{		
			listarRegistro();	
			listarRegistro2();
		}		
	});	
	
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();			
		var parametros = {
			"fecha_inicio" : $("#txtFecha_inicio").val(),
			"fecha_termino" : $("#txtFecha_termino").val(),
			"rut" : $("#txtRut").val()				
		};				
		$.ajax({
			type:'post',
			dataType: 'json',	
			url: "listado.inc.php",
			data : parametros,					
			success: function(dados)
			{ 
				 for (i=0;i<dados.length;i++){
				  if(dados[i].rut != 0){	
					  $('#example').dataTable().fnAddData( [						  
						dados[i].fecha, 
						dados[i].hora, 				
						dados[i].departamento, 	
						dados[i].sucursal,
						dados[i].tipomarcaje							
					  ]);
				  }
				}
			}
		});

	}
	
	function listarRegistro2(){

		$('#example2').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/marcajessincronizadostrabajador",	
			data : JSON.stringify({
				fecha_inicio: $("#txtFecha_inicio").val(),
				fecha_termino: $("#txtFecha_termino").val(),
				"rut" : $("#txtRut").val()					
			}),					
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
					  var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Editar</button>";	
					  $('#example2').dataTable().fnAddData( [						  
						dados[i][j].fecha,	
						dados[i][j].hora,	
						dados[i][j].departamento,	
						dados[i][j].sucursal +"<input type='hidden' value ='"+dados[i][j].id+"' />",
						dados[i][j].tipo_marcaje +"<input type='hidden' value ='"+dados[i][j].id_tipo_marcaje+"' />",
                        boton						
					  ]);
					}
				}
			}
		});

	}

    var idMarcaje;
	$("#example2").on('click','.btn-editar', function() {
		idMarcaje = $(this).parents("tr").find("td:eq(3)").find("input").val();	

		$("#txtTipo_marcaje").val($(this).parents("tr").find("td:eq(4)").find("input").val());		
		$("#txtFecha_marcaje").val($(this).parents("tr").find("td:eq(0)").html());	
		$("#txtHora_marcaje").val($(this).parents("tr").find("td:eq(1)").html());	
		$("#modal-editar-marcaje").modal("show");
	});
 
	$("#btnEditarMarcaje").click(function(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/actualizarmovimientomarcaje",
			data : JSON.stringify({
				id:idMarcaje,
				id_tipo_marcaje:$("#txtTipo_marcaje").val()					
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 201){
					toastr.success("Registro Ingresado Exitosamente", "POWERTIME");
					listarRegistro2();
				}
			}
		})		
	});
		
	$("#btnBuscar").click(function(){
		$("#modal-buscar").modal("show");		
	});
	
	$('#txtCriterio').keyup(function(e){
		if(e.keyCode == 13){
			buscarpersona();
		}
	});
	
	$("#btnFiltro").click(function(){
		buscarpersona();
	});
	
	function buscarpersona(){
		$('#example3').dataTable().fnClearTable();
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/buscarpersona",
			data : JSON.stringify({
				descripcion: $("#txtCriterio").val()			
			}),			
			success: function(dados)
			{
				$('#example3').dataTable().fnClearTable();
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
					  var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Seleccionar</button>";
					  $('#example3').dataTable().fnAddData( [
						dados[i][j].rut,						  
						dados[i][j].nombre,	
						dados[i][j].apellido,					
						boton +"<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					}
				}
			}
		});			
	}
	
	$('#txtRut').keyup(function(e){
		if(e.keyCode == 13){
			
			if( $("#txtRut").val() == null || $("#txtRut").val().length == 0 || /^\s+$/.test($("#txtRut").val()) ){
				toastr.warning("Debe Seleccionar Trabajador", "POWERTIME");
				return false;
			}else{
				$.ajax({
					type:'POST',
					contentType: 'application/json',
					dataType: "json",
					crossDomain: true,
					headers: {
						'Content-Type': 'application/json'
					},
					url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerpersonarut",
					data : JSON.stringify({
						rut: $('#txtRut').val()			
					}),			
					success: function(dados)
					{
						 for (i=0;i<dados.length;i++){					
							$("#txtRut").val(dados[i].rut);
							$("#txtNombre").val(dados[i].nombre + " " +dados[i].apellido);
							listarRegistro();
							listarRegistro2();						
						}
					}
				});					
			}			
		
		}
	});	

	$("#example3").on('click','.btn-editar', function() {
		var id = $(this).parents("tr").find("td:eq(3)").find("input").val();	
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerpersona",
			data : JSON.stringify({
				id: id			
			}),			
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){					
					$("#txtRut").val(dados[i].rut);
					$("#txtNombre").val(dados[i].nombre + " " +dados[i].apellido);
					$("#modal-buscar").modal("toggle");	
					listarRegistro();
					listarRegistro2();						
				}
			}
		});			
	});		
	
});
</script>
</body>
</html>
