<?php include_once("../lib/control.seguridad.php"); ?>
<?php
	$fecha_inicio = date('d-m-Y', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('d-m-Y', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />   
 
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" /> 
  <style>
	  #example{
		  font-size:10px;	  
	  }
	  #example2{
		  font-size:10px;	  
	  }
	  .content-header h4{ 
		  font-size: 20px
	  }	  
      .dataTables_wrapper { font-size: 10px }	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <h4>Consulta Permisos ACEPTA</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			  <div class="form-row align-items-center">
				<div class="col-md-3">
				  <div class="input-group input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">&Aacute;rea</div>
					</div>
					<select class="form-control" id="txtSucursal"> </select>
				  </div>
				</div>	
				<div class="col-md-3">
				  <div class="input-group input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Centro</div>
					</div>
					<select class="form-control" id="txtDepartamento">
						<option value="0">Seleccione...</option>
					</select>
				  </div>
				</div>						
				<div class="col-md-3">
				  <button type="button" class="btn btn-info btn-sm btn-block" id="btnAgregar">Agregar a Filtro</button>
				</div>	
				<div class="col-md-3">
				  <button type="button" class="btn btn-info btn-sm btn-block" id="btnProcesar">Consultar</button>
				</div>	
													  					
			  </div>

	  		  <div class="row mt-2">
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Estado</div>
					</div>
					<select class="form-control" id="txtEstado"> </select>
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Inicio</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Termino</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
				  </div>
				</div>				
			  </div>


            </div>
            <!-- /.card-header -->
            <div class="card-body">
			<button type="button" class="btn btn-outline-info btn-sm" id="btnShowDepto">Ocultar Centros Seleccionados</button>
              <table id="example" class="table table-bordered table-striped text-center">
                <thead>
                <tr>	
				  <th>AREA</th>	
				  <th>DEPARTAMENTO</th>				  
				  <th></th>					  
                </tr>
                </thead>			
              </table>

              <table id="example2" class="table table-bordered table-striped text-center">
                <thead>
                <tr>	
				  <th>FOLIO</th>	
				  <th>CODIGO ACEPTA</th>	
                  <th>&Aacute;REA</th>	
                  <th>CENTRO</th>					  
                  <th>FECHA INICIO</th>				
                  <th>FECHA TERMINO</th>	
                  <th>CANTIDAD DIAS</th>					  
                  <th>ESTADO DE PERMISO</th>					  
                  <th>TIPO DE PERMISO</th>				
                  <th>RUT</th>
				  <th>TRABAJADOR</th>				  
				  <th></th>					  
                </tr>
                </thead>			
              </table>

			  <div class="div-response"></div>
            </div>
			<div class="card-footer">
			</div>			
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>

  <div class="modal" id="modalvisor" tabindex="-1" role="dialog"  id="modal-default">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Visor de Documentos</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body modal-body-informe">
        <iframe name="iframe3" width="100%" height="100%" src="../inc/loading.php"></iframe>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>  

<!-- Modal -->
<div class="modal fade" id="modalMensaje" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">PowerTime</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="mensajeusuario">
 
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" id="btnCerrar"><i class="fas fa-backspace"></i> Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalConfirmar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">PowerTime</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" >
	  	&iquest; Desea Eliminar Centro de la Lista ?
      </div>
      <div class="modal-footer">
	  	<button type="button" class="btn btn-danger" id="btnEliminar"><i class="far fa-trash-alt"></i> Eliminar</button>
        <button type="button" class="btn btn-secondary" id="btnCerrarModal"><i class="fas fa-backspace"></i> Cerrar</button>
      </div>
    </div>
  </div>
</div>

 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../plugins/jQueryUI/jquery-ui.js"></script>
<script src="https://unpkg.com/pdfobject@2.2.4/pdfobject.min.js"></script>
<script src="../plugins/toastr/toastr.js"></script>
<script>
  $(function () { 
  
    $(".modal-body-informe").height(parseInt(screen.height) -400);  	
	
    $('#example').DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 		  
    });

    $('#example2').DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 		  
    });	

	$.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'dd/mm/yy',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 }) 		
		
	
	combo();
	function combo(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/sucursal",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtSucursal').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				departamento();
			}
		});	
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/permisotipoestado",		
			success: function(dados)
			{
				$('#txtEstado').append($('<option>', {
					value: 0,
					text : "Todos..."
				}));

				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtEstado').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
			}
		});	

	}
	
	$("#txtSucursal").change(function () {
		departamento();
    });

	function departamento(){
		$('#txtDepartamento').empty();	
		$('#txtDepartamento').append($('<option>', {
			value: 0,
			text : "Seleccione..."
		}));			
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/obtenerdepartamentosucursal",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),								
			}),			
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
			}
		});			
	}	

	$("#btnAgregar").click(function(){
		if(parseInt($('#txtDepartamento').val()) == 0){
			$("#mensajeusuario").html("Debe Seleccionar Departamento");
			$("#modalMensaje").modal("show");
		}else{
			$.ajax({
				type:'POST',
				contentType: 'application/json',
				dataType: "json",
				crossDomain: true,
				headers: {
					'Content-Type': 'application/json'
				},
				url: "http://200.24.13.60/~program1/power-time-api/public/obtenernombredepartamentosucursal",		
				data : JSON.stringify({
					id_departamento: parseInt($('#txtDepartamento').val()),								
				}),						
				success: function(dados)
				{
					var boton = "<button type='button' class='btn btn-outline-danger btn-sm btn-eliminar'><i class='far fa-trash-alt'></i> Eliminar</button>";
					$('#example').dataTable().fnAddData( [						  
						dados[0].sucursal,
						dados[0].departamento,	
						boton + "<input type='hidden' value ='"+dados[0].id+"' />"							
					]);
				}
			});	
		}
	});

	$("#btnShowDepto").click(function(){

		if(document.getElementById("example").classList.contains("d-none")){
			document.getElementById("example").classList.remove("d-none");
			$(this).text("Ocultar Centros Seleccionados");
		}else{
			document.getElementById("example").classList.add("d-none");
			$(this).text("Ver Centros Seleccionados");
		}
		
	});

	var columna;
	$("#example").on('click','.btn-eliminar', function() {
		var id = $(this).parents("tr").find("td:eq(2)").find("input").val();
		columna = $(this).parents("tr");
		$("#modalConfirmar").modal("show");
	});	

	$("#btnEliminar").click(function(){
		$("#example").dataTable().fnDeleteRow(columna, null, true);
		$("#modalConfirmar").modal("toggle");
	});	

	$("#btnCerrar").click(function(){
		$("#modalMensaje").modal("toggle");
	});      

	$("#btnCerrarModal").click(function(){
		$("#modalConfirmar").modal("toggle");
	});    

	var departamentos =  new Array(); 
	$("#btnProcesar").click(function(){
		if($('#example').dataTable().fnGetData().length == 0){
			$("#mensajeusuario").html("Debe Seleccionar Departamento");
			$("#modalMensaje").modal("show");
		}else{
			$('#example2').dataTable().fnClearTable();
			$('#example tbody tr').each(function() {
				departamentos.push($(this).find("td:eq(2)").find("input").val());

				$.ajax({
					type:'POST',
					contentType: 'application/json',
					dataType: "json",
					crossDomain: true,
					headers: {
						'Content-Type': 'application/json'
					},
					url: "http://200.24.13.60/~program1/power-time-api/public/permisoestadoacepta",	
					data : JSON.stringify({
						fecha_inicio: invertirCadena($("#txtFecha_inicio").val()),
						fecha_termino: invertirCadena($("#txtFecha_termino").val()),	
						id_departamento: $(this).find("td:eq(2)").find("input").val(),	
						id_estado: $("#txtEstado").val()								
					}),				
					success: function(dados)
					{  
						var dias = ["Lun", "Mar", "Mie", "Jue", "Vie", "Sab", "Dom"];
					
						for (i=0;i<dados.length;i++){
							for (j=0;j<dados[i].length;j++){
							var fecha_inicio  = new Date(dados[i][j].fecha_inicio);
							var fecha_termino  = new Date(dados[i][j].fecha_termino);					  
							
							$('#example2').dataTable().fnAddData( [
									dados[i][j].id,
									dados[i][j].pdfacepta,
									dados[i][j].sucursal,
									dados[i][j].departamento,
									convertDateFormat(dados[i][j].fecha_inicio),	
									convertDateFormat(dados[i][j].fecha_termino),
									dados[i][j].cantidad + "<input type='hidden' value ='"+dados[i][j].id+"' />",						
									dados[i][j].estado,
									dados[i][j].tipo,	
									dados[i][j].rut,	
									dados[i][j].nombre+" "+dados[i][j].apellido,
									"<button type='button' class='btn btn-outline-info btn-sm'><i class='fas fa-file-contract'></i> Ver Documento</button></td>"
							]);
							}
						}
					}
				});

			});
			document.getElementById("example").classList.add("d-none");
			$(this).text("Ver Centros Seleccionados");
		}
	});

	$("#example2").on('click','.btn-outline-info', function() {
	  var codigo = $(this).parents("tr").find("td:eq(1)").html();
	  PDFObject.embed("../sincronizaacepta/verdocumento.php?codigo="+codigo, ".modal-body-informe");		
	  $("#modalvisor").modal("show");
	});    	

	function invertirCadena(numeros) { 
        return numeros.split('-').reverse().join('-')
    }	

	function convertDateFormat(string) {
        var info = string.split('-').reverse().join('-').split('-');
        return info[0]+"-"+info[1]+"-"+info[2];
    }	

});
</script>
</body>
</html>
