<?php include_once("../lib/control.seguridad.php"); ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
 
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />  
	  <style>
	  #example{
		  font-size:10px;
	  }
	  .content-header h4{ 
		  font-size: 20px
	  }
     .dataTables_wrapper { font-size: 10px; }	
	.dataTables_filter input { height: 25px; }	   
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <h4>Usuarios Inactivos</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			
				<div class="form-row">
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">&Aacute;rea</div>
						</div>
						<select class="form-control" id="txtSucursal"> </select>
					  </div>
					</div>	
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Centro</div>
						</div>
						<select class="form-control" id="txtDepartamento">
							<option value="0">Todos...</option>
						</select>
					  </div>
					</div>	
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Nombre / Rut</div>
						</div>
						<input type="text" class="form-control" id="txtRut" value="">
					  </div>
					</div>		
					<div class="col-md-2">
					    <button type='button' class='btn btn-info btn-sm btn-block' id='btnEnviar' name='btnEnviar'>Filtrar</button>
					</div>						
				</div>	
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                <tr>			
                  <th>RUT</th>				
                  <th>NOMBRE</th>	
                  <th>TURNO</th>
                  <th>CARGO</th>	
                  <th>CENTRO</th>					  
                  <th></th>					  
                </tr>
                </thead>			
              </table>
			  <div class="div-response"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div id="modal-activar" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<p>&iquest; Desea Activar Cuenta de Usuario ? <br /> Una vez Activada la cuenta podr&aacute; trabajar con informaci&oacute;n de Usuario</p>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
			<button type="button" class="btn btn-info" id="btn-confirmar">Confirmar</button>
		  </div>
		</div>
	  </div>
	</div>    
  
 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script> 
 
<script>
  $(function () { 
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });
	
	combo();
	function combo(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/sucursal",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtSucursal').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				departamento();
			}
		});				
	}

	$("#txtSucursal").change(function () {
		departamento();
    });

	function departamento(){
		$('#txtDepartamento').empty();	
		$('#txtDepartamento').append($('<option>', {
			value: 0,
			text : "Todos..."
		}));		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerdepartamentosucursal",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),								
			}),			
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				listarRegistro();
			}
		});			
	}	
	
	$("#txtDepartamento").change(function () {
		listarRegistro();
    });
    
	$("#txtRut").keyup(function(e){
		if(e.keyCode == 13){
			buscarPersona();
		}
	});	
	
    $("#btnEnviar").click(function(){
		buscarPersona();        
    });
	
    function buscarPersona(){
		$('#example').dataTable().fnClearTable();
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/buscarpersonainactiva",
			data : JSON.stringify({
				descripcion: $("#txtRut").val()			
			}),			
			success: function(dados)
			{
				$('#example3').dataTable().fnClearTable();
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
					  var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Ver Ficha</button> ";
					  var boton2 = " <button type='button' class='btn btn-info btn-xs btn-activar'>Activar Usuario</button> ";					  
					  $('#example').dataTable().fnAddData( [
						dados[i][j].rut,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].turno,	
						dados[i][j].cargo,	
						dados[i][j].departamento,							
						boton2 + boton + "<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					}
				}
			}
		});			
	}

	var idEliminar;	
	$("#example").on('click','.btn-activar', function() {			
		$('#modal-activar').modal("show");
	    idEliminar = $(this).parents("tr").find("td:eq(5)").find("input").val();
	});		

	$("#btn-confirmar").click(function(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/activarpersona",
			data : JSON.stringify({
				id:idEliminar		
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 201){
					$('#modal-activar').modal("toggle");					
					listarRegistro();
                     toastr.success("Usuario Activado Exitosamente", "POWERTIME");					
				}
			}
		})		
	});    
    
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerpersonadepartamentosucursalinactiva",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),					
				id_departamento: $('#txtDepartamento').val(),								
			}),		
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Ver Ficha</button> ";		
					  var boton2 = " <button type='button' class='btn btn-info btn-xs btn-activar'>Activar Usuario</button> ";						  
					  $('#example').dataTable().fnAddData( [
						dados[i][j].rut,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].turno,	
						dados[i][j].cargo,
						dados[i][j].departamento,							
						boton2 + boton + "<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					}
				}
			}
		});

	}
	
	$("#example").on('click','.btn-editar', function() {
		var id = $(this).parents("tr").find("td:eq(5)").find("input").val();
		$('.div-response').html('<form action="index.php" name="form" method="post" style="display:none;"><input type="text" name="txtId" id="txtId" value="'+ id +'" /></form>');
		document.forms['form'].submit();
	});	
		
});
</script>
</body>
</html>
