<?php
set_time_limit(0);
ini_set('memory_limit', '-1');

require_once ('../librerias/dompdf/autoload.inc.php');
use Dompdf\Dompdf;

$html = '';
$html .='
<style>
	table {
		width:100%;
	}
body{
	font-family:Arial;
}
	table {
	font-size:11px;
	}
	.tbl-marcaje{
		text-align: center;
	}
    .tbl-marcaje th {
      color: #000000;
	  background-color: #CCCCCC;
	  border:solid 1px #000000;
	}
    .tbl-marcaje td {
		border:solid 1px #000000;
	  }	
    .tbl-marcaje tr {
        background-color: #eee;
    }
    .tbl-marcaje tr:nth-child(2) {
        background-color: #eee;
    }
    .tbl-marcaje tr:nth-child(even) {
        background-color: #eee;
    }
     
    .tbl-marcaje tr:nth-child(odd) {
        background-color: #fff;
    }
    .tbl-cabecera{
		width:100%;
	}
</style>';

    setlocale(LC_TIME, "spanish");

	$departamento = $_POST["departamento"];
	$fecha_inicio = $_POST["fecha_inicio"];
	$fecha_termino = $_POST["fecha_termino"];
	$sucursal = $_POST["sucursal"];	
	
	$ch = curl_init('http://200.24.13.60/~program1/power-time-api/public/obtenerpersonadepartamento'); 
	$payload = json_encode(array('id_departamento' => $departamento));
	curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
	$result = curl_exec($ch); 
	$array = json_decode($result);	
	
	
	$ch2 = curl_init('http://200.24.13.60/~program1/power-time-api/public/obtenersucursal'); //create a new cURL resource
	$payload2 = json_encode(array('id' => $sucursal));
	curl_setopt($ch2, CURLOPT_POSTFIELDS, $payload2);//attach encoded JSON string to the POST fields
	curl_setopt($ch2, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
	curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
	$result2 = curl_exec($ch2); //execute the POST request
	$array2 = json_decode($result2);

	$descripcion = $array2[0]->descripcion;			
	
	curl_close($ch2); 	
	
	/****************************************************************/
	
	$ch3 = curl_init('http://200.24.13.60/~program1/power-time-api/public/obtenerdepartamento'); //create a new cURL resource
	$payload3 = json_encode(array('id' => $departamento));
	curl_setopt($ch3, CURLOPT_POSTFIELDS, $payload3);//attach encoded JSON string to the POST fields
	curl_setopt($ch3, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
	curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
	$result3 = curl_exec($ch3); //execute the POST request
	$array3 = json_decode($result3);

	$descripcion_departamento = $array3[0]->descripcion;			
	
	curl_close($ch3); 		


	$html .= "<table class='tbl-cabecera' style='border-bottom: 2px solid #000000;'>";
	$html .= "<tr>";
	$html .= "<td width='30%;'><img src='../img/002.png' style='max-height:45px;' /></td>";
	$html .= "<td width='50%;'><h3 style='display:inline;'>REPORTE DE ASISTENCIA LABORAL</h3></td>";
	$html .= "</tr>";			
	$html .= "</table>";	

	$html .= "<table class='tbl-cabecera'>";
	$html .= "<tr>";
	$html .= "<td colspan='3'><b>FECHA EMISION :</b> ".date("d-m-Y")."</td>";
	$html .= "</tr>";
	$html .= "<tr>";
	$html .= "<td colspan ='2'><b>COMPA&Ntilde;IA :</b> CORP MUNICIPAL PARA EL DESARROLLO SOCIAL</td>";
	$html .= "<td><b>PERIODO DESDE :</b> ".$fecha_inicio."</td>";			
	$html .= "</tr>";	
	$html .= "<tr>";
	$html .= "<td colspan ='2'><b>RUT :</b> 70.983.600-5</td>";
	$html .= "<td><b>PERIODO HASTA :</b> ".$fecha_termino."</td>";
	$html .= "</tr>";	
	$html .= "<tr>";
	$html .= "<td colspan ='3'><b>SUCURSAL :</b> ".STRTOUPPER($descripcion)."</td>";
	$html .= "</tr>";	
	$html .= "<tr>";
	$html .= "<td colspan ='3'><b>DEPARTAMENTO :</b> ".STRTOUPPER($descripcion_departamento)."</td>";
	$html .= "</tr>";		
	$html .= "</table><br />";
        
		
	$html .= "<table class='tbl-marcaje'>";
	$html .= "<thead>";
	$html .= "<tr>";	
	$html .= "<th>Fecha</th>";	
 	$html .= "<th>Permiso</th>";	
	$html .= "<th>Turno</th>";	
	$html .= "<th>Entrada</th>";	
	$html .= "<th>Salida</th>";
	$html .= "<th>Total Horas</th>";	
	$html .= "<th>Trabajador</th>";				
	$html .= "</tr>";
	$html .= "</thead>";
	$html .= "<tbody>";

	foreach ($array[0] as $row) {
		$rut = $row->rut;
		$id_persona = $row->id;
		
		$ch2 = curl_init('http://200.24.13.60/~program1/power-time-api/public/informemarcatrabajador'); 
		$payload2 = json_encode(array('fecha_inicio' => $fecha_inicio, 'fecha_termino' => $fecha_termino, 'rut' => $rut, 'id_persona' => $id_persona));
		curl_setopt($ch2, CURLOPT_POSTFIELDS, $payload2);
		curl_setopt($ch2, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true); 
		$result2 = curl_exec($ch2); 
		$array2 = json_decode($result2);
        
		$entradap = "00:00:00";
		$salidap = "00:00:00";
		$entradar = "00:00:00";	
		$salidar = "00:00:00";
		$trabajoprogramado = "00:00:00";
		$trabajoreal = "00:00:00";
		
		
        foreach ($array2[0] as $row2) {
			$permiso = $row2->obs;
			if(empty($permiso)) { $permiso = "NO"; }

			if(!empty($row->entradap)) { $entradap = suma_horas($entradap, $row->entradap); }	
			if(!empty($row->salidap)) { $salidap = suma_horas($salidap, $row->salidap); }	
			if(!empty($row->entradar)) { $entradar = suma_horas($entradar, $row->entradar); }	
			if(!empty($row->salidar)) { $salidar = suma_horas($salidar, $row->salidar); }	
			if(!empty($row->trabajoprogramado)) { $trabajoprogramado = suma_horas($trabajoprogramado, $row->trabajoprogramado); }	
			if(!empty($row->trabajoreal)) { $trabajoreal = suma_horas($trabajoreal, $row->trabajoreal); }
			
			
			$newDate = date("d-m", strtotime($row2->fecha));
			
			if(empty($row2->nombre) && empty($row2->apellido)) { continue; }
			
			$html .= "<tr>";
			$html .= "<td>". substr(strftime("%A", strtotime($row2->fecha)), 0, 3) ." ". $newDate ."</td>";
			$html .= "<td>". $permiso ."</td>";				
			$html .= "<td>". cortarCadena($row2->entradap) ." ".cortarCadena($row2->salidap) ."</td>";
			$html .= "<td>". cortarCadena($row2->entradar) ."</td>";	
			$html .= "<td>". cortarCadena($row2->salidar) ."</td>";
			$html .= "<td>". cortarCadena($row2->trabajoreal) ."</td>";
			$html .= "<td>". $row2->nombre ." ".$row2->apellido ."</td>";
			$html .= "</tr>";					
							
		}			
		
	}		

	$html .= "</tbody>";
	$html .= "</table>";

	
	curl_close($ch); 


	function cortarCadena($hora){	
		if($hora != null) { $hora = str_replace("-","", $hora); $hora = substr($hora, 0, 5); return $hora; } else return $hora;
	}	

	function suma_horas($hora1,$hora2){
		
		$hora1 = str_replace("-","", $hora1);
		$hora2 = str_replace("-","", $hora2);	
			
		$hora1=explode(":",$hora1);
		$hora2=explode(":",$hora2);
		
		$temp=0;
		$segundos=(int)$hora1[2]+(int)$hora2[2];
		while($segundos>=60){
			$segundos=$segundos-60;
			$temp++;
		}
		$minutos=(int)$hora1[1]+(int)$hora2[1]+$temp;
		$temp=0;
		while($minutos>=60){
			$minutos=$minutos-60;
			$temp++;
		}

		$horas=(int)$hora1[0]+(int)$hora2[0]+$temp;
		if($horas<10){ $horas= '0'.$horas; }
		if($minutos<10){ $minutos= '0'.$minutos; }
		if($segundos<10){ $segundos= '0'.$segundos; }

		$sum_hrs = $horas.':'.$minutos.':'.$segundos;
		return ($sum_hrs);

	}	


$pdf = new DOMPDF();
$pdf->set_paper("A4", "landscape");
$pdf->load_html(utf8_encode($html));
$pdf->render();
$pdf->stream("marcajes.pdf", array("Attachment" => false));
exit(0);


?>
