<?php include_once("../lib/control.seguridad.php"); ?>
<?php
	$fecha_inicio = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('Y-m-d', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">   
 
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" /> 
  <style>
  #example{
	  font-size:10px;
  }
      .dataTables_wrapper { font-size: 10px }	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Informe Inspecci&oacute;n</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Informe Inspecci&oacute;n</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			  <div class="form-row align-items-center">
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Inicio</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
				  </div>
				</div>
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Termino</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
				  </div>
				</div>				
				<div class="col-md-2">
				  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnBuscar">Buscar</button>
				</div>
				<div class="col-md-2">
				  <button type="button" class="btn btn-danger mb-2 btn-sm" id="btnInforme">Informe PDF</button>
				</div>					
			  </div>
			  <div class="form-row align-items-center">
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Sucursal</div>
					</div>
					<select class="form-control" id="txtSucursal"> </select>
				  </div>
				</div>
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Departamento</div>
					</div>
					<select class="form-control" id="txtDepartamento">
						<option value="0">Seleccione...</option>
					</select>
				  </div>
				</div>				

			  </div>			  
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                <tr>			
                  <th>FECHA</th>	
                  <th>PERMISO</th>	
                  <th>TURNO</th>	
                  <th>ENTRADA</th>	
                  <th>SALIDA</th>
                  <th>TOTAL HORAS</th>	
                  <th>TRABAJADOR</th>					  
                </tr> 
                </thead>			
              </table>
			  <div class="div-response"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
 
<div class="modal" tabindex="-1" role="dialog"  id="modal-default">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <label class="modal-title">Visor de Documentos</label>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <iframe name="iframe3" width="100%" height="100%" src="../inc/loading.php"></iframe>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div> 

<div class="modal" tabindex="-1" role="dialog"  id="modal-loading">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <label class="modal-title">Powertime, Procesando...</label>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" style='text-align:center;'>
        <img src="../img/loading.gif" />
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div> 
 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/jQueryUI/jquery-ui.js"></script>
 
<script>
  $(function () { 
  
    $(".modal-body").height(parseInt(screen.height) -400);  
  
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	
    });
	
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 }) 

	combo();
	function combo(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/sucursal",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtSucursal').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				departamento();
			}
		});				
	}

	$("#txtSucursal").change(function () {
		departamento();
    });

	function departamento(){
		$('#txtDepartamento').empty();	
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/obtenerdepartamentosucursal",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),								
			}),			
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				listarRegistro();
			}
		});			
	}	
	
	$("#txtDepartamento").change(function () {
		listarRegistro();
    });		 
	
	$("#btnBuscar").click(function(){
		listarRegistro();
	});
	
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		var parametros = {
			"fecha_inicio": $("#txtFecha_inicio").val(),
			"fecha_termino": $("#txtFecha_termino").val(),
			"departamento": $("#txtDepartamento").val()	
		};

		$.ajax({
			type:'POST',
			dataType: 'json',
			url: "index.inc.php",
			data : parametros,	
			beforeSend : function()
			{
				$('#modal-loading').modal('show');
			},			
			success: function(dados)
			{
			     var dias = ["Lun", "Mar", "Mie", "Jue", "Vie", "Sab", "Dom"];
				 
				 for (i=0;i<dados.length;i++){	
				 
				  var fecha_inicio  = new Date(dados[i].fecha);
				  
				  if(dados[i].entradap == null && dados[i].salidap == null) { continue; } 
				  
				  $('#example').dataTable().fnAddData( [						  
					dias[fecha_inicio.getDay()]+" "+convertDateFormat(dados[i].fecha),	
					dados[i].obs,	
					dados[i].entradap +" - "+ dados[i].salidap,	
					dados[i].entradar,	
					dados[i].salidar,	
					dados[i].trabajoreal,	
					dados[i].nombre 					
				  ]);					
				}
				$('#modal-loading').modal('toggle');
			}
		});

	}
	
	function convertDateFormat(string) {
        var info = string.split('-').reverse().join('-').split('-');
        return info[0]+"-"+info[1];
    }	

	$("#btnInforme").click(function(){

		$('.div-response').html('<form action="exportar.pdf.inc.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="fecha_inicio" name="fecha_inicio" value="'+$("#txtFecha_inicio").val()+'" >'+
		'<input type="text" class="form-control" id="fecha_termino" name="fecha_termino" value="'+$("#txtFecha_termino").val()+'"  >'+
		'<input type="text" class="form-control" id="departamento" name="departamento" value="'+$("#txtDepartamento").val()+'"  >'+		
		'<input type="text" class="form-control" id="sucursal" name="sucursal" value="'+$("#txtSucursal").val()+'"  >'+				
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');				
	});
	
	$('#modal-default').on('hidden.bs.modal', function () {
		$('.div-response').empty();
		$('.div-response').html('<form action="../inc/loading.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'</form>');			
		document.forms['form'].submit();		 
	});		
	
});
</script>
</body>
</html>
