<?php 

include_once("../lib/control.seguridad.php");

	$fecha_inicio = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('Y-m-d', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />    
  <style>
  #example{
	  font-size:10px;
  }
      .dataTables_wrapper { font-size: 10px }	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-1">
          <div class="col-sm-6">
            <h4>Planilla de Asistencia por Centro</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Planilla de Asistencia por Centro</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			
				<div class="form-row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">&Aacute;rea</div>
						</div>
						<select class="form-control" id="txtSucursal"> </select>
					  </div>
					</div>	
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Centro</div>
						</div>
						<select class="form-control" id="txtDepartamento">
							<option value="0">Seleccione...</option>
						</select>
					  </div>
					</div>	
					<div class="col-md-2">
					  <button type="button" class="btn btn-outline-danger mb-2 btn-sm" id="btnInforme">Informe PDF</button>
					  <button type="button" class="btn btn-outline-success mb-2 btn-sm" id="btnInformeExcel">Informe EXCEL</button>
					</div>									
				</div>
				
				<div class="form-row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha Inicio</div>
						</div>
						<input type="date" class="form-control" id="txtFechainicio" value="<?php echo $fecha_inicio ?>">
					  </div>
					</div>	
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha T&eacute;rmino</div>
						</div>
						<input type="date" class="form-control" id="txtFechatermino" value="<?php echo $fecha_termino ?>">
					  </div>
					</div>						
					<div class="col-md-2">
					    <button type='button' class='btn btn-info btn-sm btn-block' id='btnEnviar' name='btnEnviar'>Filtrar</button>
					</div>				
				</div>		
				
            </div>
            <div class="card-body" id="visordocumento" style="overflow-y:hidden; overflow-x:scroll; height:550px;"> </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>

    <div class="modal" tabindex="-1" role="dialog"  id="modal-default">
		<div class="modal-dialog modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Visor de Documentos</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body" id="visordocumentomodal">
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
				</div>
			</div>
		</div>
	</div>

  <div class="div-response"></div>
 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script> 
<script src="https://unpkg.com/pdfobject@2.2.4/pdfobject.min.js"></script>
<script>

	$("#visordocumento").height(parseInt(screen.height) -400);  
	$("#visordocumentomodal").height(parseInt(screen.height) -400);  	

	let idsucursal = document.getElementById('txtSucursal');
	let iddepartamento = document.getElementById('txtDepartamento');
	let fechainicio = document.getElementById('txtFechainicio');
	let fechatermino = document.getElementById('txtFechatermino');

	const mostrarficha = async() =>{
		console.log("cargando");
		PDFObject.embed("http://200.24.13.60/~program1/consultamarcajesmva/informeasistenciadepto.php?idsucursal="+idsucursal.value+"&iddepartamento="+iddepartamento.value+"&fechainicio="+fechainicio.value+"&fechatermino="+fechatermino.value, "#visordocumento");
	}

	document.getElementById("btnEnviar").onclick = () =>{
		mostrarficha();
	}

	document.getElementById("btnInforme").onclick = async() =>{
		PDFObject.embed("http://200.24.13.60/~program1/consultamarcajesmva/informeasistenciadeptopdf.php?idsucursal="+idsucursal.value+"&iddepartamento="+iddepartamento.value+"&fechainicio="+fechainicio.value+"&fechatermino="+fechatermino.value, "#visordocumentomodal");
		$("#modal-default").modal("show");
	}

	document.getElementById("btnInformeExcel").onclick = async()=>{
		$('.div-response').html('<form action="http://200.24.13.60/~program1/consultamarcajesmva/informeasistenciadeptoexcel.php" target="this" name="form" method="post" style="display:none;">'+
	'<input type="text" class="form-control form-control-sm" id="idsucursal" name="idsucursal" value="'+ idsucursal.value +'" >'+
	'<input type="text" class="form-control form-control-sm" id="fechainicio" name="fechainicio" value="'+ fechainicio.value +'" >'+
	'<input type="text" class="form-control form-control-sm" id="fechatermino" name="fechatermino" value="'+ fechatermino.value +'" >'+
	'<input type="text" class="form-control form-control-sm" id="iddepartamento" name="iddepartamento" value="'+ iddepartamento.value +'" >'+
	'</form>');
	document.forms['form'].submit();
	}	

	const listadosucursal = async() =>{
		
		var formData = new FormData();
		formData.append('metodo', 'listadoarea');

		const resultado = await fetch('http://200.24.13.60/~program1/consultamarcajesmva/controller/consultascontroller.php',{
			method: "POST",
			body: formData, 
		});
		const data = await resultado.json();
		const map = await data.map((res) =>{
			let opcion = document.createElement('option');			  
			opcion.value = res.id;
			opcion.innerHTML = res.descripcion;  
			idsucursal.appendChild(opcion);    
		}) 
		listadodepartamento(idsucursal.value); 
	}
	listadosucursal();

	document.getElementById("txtSucursal").onchange = () =>{
		listadodepartamento(idsucursal.value); 

	}

	const listadodepartamento = async(idsucursal)=>{

		var formData = new FormData();
		formData.append('metodo', 'listadodepartamento');
		formData.append('idarea', idsucursal);

		const resultado = await fetch('http://200.24.13.60/~program1/consultamarcajesmva/controller/consultascontroller.php',{
			method: "POST",
			body: formData, 
		});
		const data = await resultado.json();
		iddepartamento.innerText = null;
 
		const map = await data.map((res) =>{
			let opcion = document.createElement('option');			  
			opcion.value = res.id;
			opcion.innerHTML = res.descripcion;  
			iddepartamento.appendChild(opcion);    
		}) 

	}	



</script>
</body>
</html>
