<?php 
include_once("../lib/control.seguridad.php"); 

$fecha_inicio = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
$fecha_termino = date('Y-m-d', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 

if($_POST){
	if(!isset($_POST["rut"])){
		header('Location: listado.php');		
	}
}else{
	header('Location: listado.php');
}

?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">   
  <style>
	   #example{ font-size:10px; }
       .dataTables_wrapper { font-size: 10px }	  
  </style>    
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
 
  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Planilla de Asistencia por Trabajador</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="container-fluid">

	  <div class="row">
          <div class="col-md-12">
            <div class="card">
				<div class="card-header">
				  <div class="row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Rut</div>
						</div>
						<input type="text" class="form-control" id="rut" value="<?php echo $_POST["rut"] ?>" readonly >
					  </div>
					</div>
					<div class="col-md-8">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Nombre</div>
						</div>
						<input type="text" class="form-control" id="nombre"  readonly >
					  </div>
					</div>									
				  </div>					
				</div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-md-12">
            <div class="card">
				<div class="card-header">
				  <div class="row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha Inicio</div>
						</div>
						<input type="date" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>">
					  </div>
					</div>
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha T&eacute;rmino</div>
						</div>
						<input type="date" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" >
					  </div>
					</div>				
					<div class="col-md-2">
					  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnBuscar">Buscar</button>	  
					</div>
					<div class="col-md-2">
					  <button type="button" class="btn btn-outline-danger mb-2 btn-sm" id="btnInforme">Informe PDF</button>
					  <button type="button" class="btn btn-outline-success mb-2 btn-sm" id="btnInformeExcel">Informe EXCEL</button>
					</div>					
				  </div>					
				</div>
				<div class="card-body" id="visordocumento" style="overflow-y:hidden; overflow-x:scroll; height:550px;"> </div>
            </div>
          </div>
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  
  <?php include_once("../inc/footer.php"); ?>
  

	<div class="modal" tabindex="-1" role="dialog"  id="modal-default">
		<div class="modal-dialog modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Visor de Documentos</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body" id="visordocumentomodal">
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
				</div>
			</div>
		</div>
	</div>

	<div class="div-response"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="https://unpkg.com/pdfobject@2.2.4/pdfobject.min.js"></script>
<script>

$("#visordocumento").height(parseInt(screen.height) -400);  
$("#visordocumentomodal").height(parseInt(screen.height) -400);  

let rut = document.getElementById("rut");
let fechainicio = document.getElementById("txtFecha_inicio");
let fechatermino = document.getElementById("txtFecha_termino");

const obtenerpersona = async() =>{
	var formData = new FormData();
	formData.append('metodo', 'obtenerpersona');
	formData.append('rut', document.getElementById('rut').value);

	const resultado = await fetch('http://200.24.13.60/~program1/consultamarcajesmva/controller/consultascontroller.php',{
		method: "POST",
		body: formData, 
	});
	const data = await resultado.json();	
	document.getElementById('nombre').value = data[0].nombre +" "+data[0].apellido;
}
obtenerpersona();
	
const mostrarficha = async() =>{
	console.log("cargando");
	PDFObject.embed("http://200.24.13.60/~program1/consultamarcajesmva/informeasistencia.php?rut="+rut.value+"&fechainicio="+fechainicio.value+"&fechatermino="+fechatermino.value, "#visordocumento");
}
mostrarficha();

document.getElementById("btnBuscar").onclick = async() =>{
	mostrarficha();
}

document.getElementById("btnInforme").onclick = async() =>{
	PDFObject.embed("http://200.24.13.60/~program1/consultamarcajesmva/informeasistenciapdf.php?rut="+rut.value+"&fechainicio="+fechainicio.value+"&fechatermino="+fechatermino.value, "#visordocumentomodal");
	$("#modal-default").modal("show");
}

document.getElementById("btnInformeExcel").onclick = async()=>{
    $('.div-response').html('<form action="http://200.24.13.60/~program1/consultamarcajesmva/informeasistenciaexcel.php" target="this" name="form" method="post" style="display:none;">'+
   '<input type="text" class="form-control form-control-sm" id="rutpersona" name="rutpersona" value="'+ rut.value +'" >'+
   '<input type="text" class="form-control form-control-sm" id="fechainicio" name="fechainicio" value="'+ fechainicio.value +'" >'+
   '<input type="text" class="form-control form-control-sm" id="fechatermino" name="fechatermino" value="'+ fechatermino.value +'" >'+
   '</form>');
   document.forms['form'].submit();
}
</script>

</body>
</html>
