<?php include_once("../lib/control.seguridad.php"); ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />    
  <style>
  #example{
	  font-size:10px;
  }
      .dataTables_wrapper { font-size: 10px }	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-1">
          <div class="col-sm-6">
            <h4>Planilla de Asistencia por Trabajador</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Planilla de Asistencia por Trabajador</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			
				<div class="form-row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">&Aacute;rea</div>
						</div>
						<select class="form-control" id="txtSucursal"> </select>
					  </div>
					</div>	
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Centro</div>
						</div>
						<select class="form-control" id="txtDepartamento">
							<option value="0">Seleccione...</option>
						</select>
					  </div>
					</div>				
				</div>
				
				<div class="form-row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Nombre / Rut Persona</div>
						</div>
						<input type="text" class="form-control" id="txtRut" value="">
					  </div>
					</div>	
					<div class="col-md-4">
					    <button type='button' class='btn btn-info btn-sm btn-block' id='btnEnviar' name='btnEnviar'>Filtrar</button>
					</div>				
				</div>		
				
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="tabla" class="table table-bordered table-striped">
                <thead>
                <tr>			
                  <th>RUT</th>				
                  <th>NOMBRE</th>	
                  <th>TURNO</th>				
                  <th>CARGO</th>					  
                  <th style="width:180px;"></th>					  
                </tr>
                </thead>			
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  <div class="div-response"></div>
 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script> 
 
<script>

	$('#tabla').DataTable({	
		"info": false,
		"ordering":false,
		"language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
		}
	});	

	let idsucursal = document.getElementById('txtSucursal');
	let iddepartamento = document.getElementById('txtDepartamento');

	const listadosucursal = async() =>{
		
		var formData = new FormData();
		formData.append('metodo', 'listadoarea');

		const resultado = await fetch('http://200.24.13.60/~program1/consultamarcajesmva/controller/consultascontroller.php',{
			method: "POST",
			body: formData, 
		});
		const data = await resultado.json();
		const map = await data.map((res) =>{
			let opcion = document.createElement('option');			  
			opcion.value = res.id;
			opcion.innerHTML = res.descripcion;  
			idsucursal.appendChild(opcion);    
		}) 
		listado(); 
	}
	listadosucursal();

	document.getElementById("txtSucursal").onchange = () =>{
		listadodepartamento(idsucursal.value); 
		listado(); 
	}

	const listadodepartamento = async(idsucursal)=>{

		var formData = new FormData();
		formData.append('metodo', 'listadodepartamento');
		formData.append('idarea', idsucursal);

		const resultado = await fetch('http://200.24.13.60/~program1/consultamarcajesmva/controller/consultascontroller.php',{
			method: "POST",
			body: formData, 
		});
		const data = await resultado.json();
		iddepartamento.innerText = null;

		let opcion = document.createElement('option');			  
		opcion.value = 0;
		opcion.innerHTML = "Todos...";  
		iddepartamento.appendChild(opcion);        
		const map = await data.map((res) =>{
			let opcion = document.createElement('option');			  
			opcion.value = res.id;
			opcion.innerHTML = res.descripcion;  
			iddepartamento.appendChild(opcion);    
		}) 

	}	

	document.getElementById("txtDepartamento").onchange = () =>{
		listado(); 
	}	

	const listado = async() =>{
		var formData = new FormData();
		formData.append('metodo', 'listadopersonadeptoarea');
		formData.append('idsucursal', idsucursal.value);
		formData.append('iddepartamento', iddepartamento.value);

		const resultado = await fetch('http://200.24.13.60/~program1/consultamarcajesmva/controller/consultascontroller.php',{
			method: "POST",
			body: formData, 
		});
		const data = await resultado.json();
		$('#tabla').dataTable().fnClearTable();
		const map = await data.map((res) =>{
			$('#tabla').dataTable().fnAddData( [				  
				res.rut + "<input type='hidden' value ='"+res.rut+"' />",
				res.nombre +" "+ res.apellido,
				res.turno,
				res.cargo,
				'<button type="button" class="btn btn-sm btn-outline-info btn-editar btn-block ml-1"> Ver Ficha Asistencia </button>'
			])
		}) 	
	}

	$("#tabla").on('click','.btn-editar', function() {
		var rut = $(this).parents("tr").find("td:eq(0)").find("input").val();
		$('.div-response').html('<form action="index.php" name="form" method="post" style="display:none;"><input type="text" name="rut" id="rut" value="'+ rut +'" /></form>');
		document.forms['form'].submit();
	});		

</script>
</body>
</html>
