<?php include_once("../lib/control.seguridad.php"); ?>
<?php
	$fecha_inicio = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('Y-m-d', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" /> 
  
  <style>
  #example{
	  font-size:10px;
  }
   .dataTables_wrapper { font-size: 10px }	   
   .dataTables_filter input { height: 25px }   
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-11">
            <h4>Informe Hora Extra</h4>
          </div>		  
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			  <div class="row align-items-center">
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Inicio</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Termino</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
				  </div>
				</div>				
				<div class="col-md-1">
				  <button type="button" class="btn btn-info mb-2 btn-sm btn-block" id="btnBuscar">Buscar</button>
				</div>
				<div class="col-md-5">
					<button type="button" class="btn btn-info btn-sm float-right" id="btnImprimir">Imprimir Informe</button>
				</div>
			  </div>			  			  
            </div>
            <!-- /.card-header -->
            <div class="card-body">
			  <div class="row">
				<div class="col-md-5">
					<div class="chart">
					  <canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
					</div>	
                    <table id="example2" class="table table-bordered table-striped">
						<thead>
							<tr>				
							  <th>SUCURSAL</th>	
							  <th>DEPARTAMENTO</th>						  
							  <th>TOTAL</th>						  				  
							</tr>
						</thead>			
				  </table>						
				</div>			  
				<div class="col-md-7">
				  <table id="example" class="table table-bordered table-striped">
					<thead>
						<tr>			
						  <th>FECHA</th>				
						  <th>H.E. APROBADA</th>				
						  <th>TRABAJADOR</th>	
						  <th>SUCURSAL</th>	
						  <th>DEPARTAMENTO</th>						  
						  <th>TURNO</th>	
						  <th>CARGO</th>					  				  
						</tr>
					</thead>			
				  </table>	
				</div>
			  </div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div class="modal" tabindex="-1" role="dialog"  id="modal-default">
	  <div class="modal-dialog modal-xl" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">Visor de Documentos</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body modal-body-informe">
			<iframe name="iframe3" width="100%" height="100%" src="../inc/loading.php"></iframe>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
		  </div>
		</div>
	  </div>
	</div>  	

   <div class="div-response"></div>
  
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<!-- ChartJS -->
<script src="../plugins/chart.js/Chart.min.js"></script>

<script src="../plugins/jQueryUI/jquery-ui.js"></script>
<script>
  $(function () { 

    $(".modal-body-informe").height(parseInt(screen.height) -400);  	 

    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": false,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      }	 		  
    });
	
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": false,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      }	 		  
    });	
	
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 }) 	
	
	$("#btnBuscar").click(function(){
		listarRegistro();
		generarGrafico();
	});
	
	listarRegistro();
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/informehoraextra",	
			data : JSON.stringify({
				fecha_inicio: $("#txtFecha_inicio").val(),
				fecha_termino: $("#txtFecha_termino").val()					
			}),						
			success: function(dados)
			{
				$('#example').dataTable().fnClearTable();
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  $('#example').dataTable().fnAddData( [
						dados[i][j].fecha,	
						dados[i][j].cantidad,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].sucursal,	
						dados[i][j].departamento,							
						dados[i][j].turno,	
						dados[i][j].cargo,							
					  ]);
					}
				}
			}
		});
		
		$('#example2').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/informehoraextracantidad",	
			data : JSON.stringify({
				fecha_inicio: $("#txtFecha_inicio").val(),
				fecha_termino: $("#txtFecha_termino").val()					
			}),						
			success: function(dados)
			{
				$('#example2').dataTable().fnClearTable();
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  $('#example2').dataTable().fnAddData( [
						dados[i][j].sucursal,	
						dados[i][j].departamento,							
						dados[i][j].total						
					  ]);
					}
				}
			}
		});		
        generarGrafico();
	}
	generarGrafico();
	function generarGrafico(){
		
      $('#barChart').remove(); // this is my <canvas> element
      $('.chart').append('<canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>');		
		
		var meses = new Array();
		var cantidad = new Array();

		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/informehoraextradiariaautorizada",			
			data : JSON.stringify({
				fecha_inicio: $("#txtFecha_inicio").val(),
				fecha_termino: $("#txtFecha_termino").val()							
			}),			
			success: function(dados)
			{				 
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){						
						meses.push (dados[i][j].fecha);
						cantidad.push (parseInt(dados[i][j].cantidad));						
					}
				 }
						
				var areaChartData = {
				  labels  : meses,
				  datasets: [
					{
					  label               : 'H.E AUTORIZADA',
					  backgroundColor     : 'rgba(210, 214, 222, 1)',
					  borderColor         : 'rgba(210, 214, 222, 1)',
					  pointRadius         : false,
					  pointColor          : 'rgba(210, 214, 222, 1)',
					  pointStrokeColor    : '#c1c7d1',
					  pointHighlightFill  : '#fff',
					  pointHighlightStroke: 'rgba(220,220,220,1)',
					  data                : cantidad
					}
				  ]
				}	  
				
				
				var barChartCanvas = $('#barChart').get(0).getContext('2d');
 		 		 
			 
				var barChartData = jQuery.extend(true, {}, areaChartData)
				var temp0 = areaChartData.datasets[0]
				barChartData.datasets[0] = temp0

				var barChartOptions = {
				  responsive              : true,
				  maintainAspectRatio     : false,
				  datasetFill             : false			  
				}
		 	    
				var barChart = new Chart(barChartCanvas, {
				  type: 'bar', 
				  data: barChartData,
				  options: barChartOptions
				})		
				
			}
		});		
			
	}		

     $("#btnImprimir").click(function(){
        $('#modal-usuario').modal("toggle");
		$('.div-response').html('<form action="exportar.pdf.inc.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtFecha_inicio" name="txtFecha_inicio" value="'+$("#txtFecha_inicio").val()+'" >'+	
		'<input type="text" class="form-control" id="txtFecha_termino" name="txtFecha_termino" value="'+$("#txtFecha_termino").val()+'" >'+			
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');				
	});
	
	$('#modal-default').on('hidden.bs.modal', function () {
		$('.div-response').empty();
		$('.div-response').html('<form action="../inc/loading.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'</form>');			
		document.forms['form'].submit();		 
	});	
	
 	
});
</script>
</body>
</html>
