<?php include_once("../lib/control.seguridad.php"); ?>
<?php
	$fecha_inicio = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('Y-m-d', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
 
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />  
   <style>
	  #example{
		  font-size:10px;
	  }
	  .content-header h4{ 
		  font-size: 20px
	  }
     .dataTables_wrapper { font-size: 10px; }	
	.dataTables_filter input { height: 25px; }	   
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <h4>Informe de Justificaci&oacute;n</h4>
          </div>
          <div class="col-sm-6">		  
			<button type='button' class='btn btn-info btn-sm float-right' id='btnInforme' name='btnInforme'>Generar Informe</button>		
          </div>			
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			
				<div class="row">
					<div class="col-md-2">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Sucursal</div>
						</div>
						<select class="form-control" id="txtSucursal"> 
							<option value="0">Todos...</option>
						</select>
					  </div>
					</div>	
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Departamento</div>
						</div>
						<select class="form-control" id="txtDepartamento">
							<option value="0">Todos...</option>
						</select>
					  </div>
					</div>	
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha Inicio</div>
						</div>
						<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
					  </div>
					</div>
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha T&eacute;rmino</div>
						</div>
						<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
					  </div>
					</div>			
					<div class="col-md-1">
					    <button type='button' class='btn btn-info btn-sm btn-block' id='btnEnviar' name='btnEnviar'>Filtrar</button>
					</div>						
				</div>	
            </div>
            <!-- /.card-header -->
            <div class="card-body">
				<div class="row">
					<div class="col-md-4">
						<div class="chart">
						  <canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
						</div>		
						  <table id="example2" class="table table-bordered table-striped">
							<thead>
							<tr>			
							  <th>SUCURSAL</th>
							  <th>DEPARTAMENTO</th>		
							  <th>TOTAL</th>									  
							</tr>
							</thead>			
						  </table>						
					</div>
					<div class="col-md-8">
					  <table id="example" class="table table-bordered table-striped">
						<thead>
						<tr>			
						  <th>RUT</th>				
						  <th>NOMBRE</th>	
						  <th>FECHA</th>
						  <th>SUCURSAL</th>
						  <th>DEPARTAMENTO</th>						  
						</tr>
						</thead>			
					  </table>
					  <div class="div-response"></div>						  
					</div>
				</div>
            </div>
		
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div class="modal" tabindex="-1" role="dialog"  id="modal-default">
	  <div class="modal-dialog modal-xl" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">Visor de Documentos</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body modal-body-informe">
			<iframe name="iframe3" width="100%" height="100%" src="../inc/loading.php"></iframe>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
		  </div>
		</div>
	  </div>
	</div>   
  
 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script> 
<!-- ChartJS -->
<script src="../plugins/chart.js/Chart.min.js"></script>
 
<script>
  $(function () { 
  
    $(".modal-body-informe").height(parseInt(screen.height) -400);  
	
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });
	
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });
	
	combo();
	function combo(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/sucursal",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtSucursal').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				departamento();
			}
		});				
	}

	$("#txtSucursal").change(function () {
		departamento();
    });

	function departamento(){
		$('#txtDepartamento').empty();	
		$('#txtDepartamento').append($('<option>', {
			value: 0,
			text : "Todos..."
		}));		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerdepartamentosucursal",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),								
			}),			
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				listarRegistro();
			}
		});			
	}	
	
	$("#txtDepartamento").change(function () {
		listarRegistro();
    });
      
	$("#btnEnviar").click(function(){
		listarRegistro();		
	});
    
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/informejustificaciondepartamento",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),				
				id_departamento: $('#txtDepartamento').val(),
				fecha_inicio: $('#txtFecha_inicio').val(),
				fecha_termino: $('#txtFecha_termino').val(),				
			}),		
			success: function(dados)
			{
				$('#example').dataTable().fnClearTable();
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){											  
					  $('#example').dataTable().fnAddData( [
						dados[i][j].rut,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].fecha,
						dados[i][j].sucursal,
						dados[i][j].departamento						
					  ]);
					}
				}
			}
		});
        generarGrafico();
	}
	
 
	function generarGrafico(){
	  $('#example2').dataTable().fnClearTable();	
      $('#barChart').remove(); // this is my <canvas> element
      $('.chart').append('<canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>');		
		
		var meses = new Array();
		var cantidad = new Array();

		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/informejustificaciondepartamentocantidad",			
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),				
				id_departamento: $('#txtDepartamento').val(),
				fecha_inicio: $('#txtFecha_inicio').val(),
				fecha_termino: $('#txtFecha_termino').val(),							
			}),			
			success: function(dados)
			{
                 $('#example2').dataTable().fnClearTable();				
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){	

					  $('#example2').dataTable().fnAddData( [
						dados[i][j].sucursal,
						dados[i][j].departamento,
						dados[i][j].total						
					  ]);					
						
						var cadena =  dados[i][j].departamento.split(" ");
						var departamento = "";
						for (var iterador = 0; iterador < cadena.length; iterador++) {
						    departamento += cadena[iterador].substring(0, 3)+ " ";
						}
						var cadena =  dados[i][j].sucursal.split(" ");
						var sucursal = "";
						for (var iterador = 0; iterador < cadena.length; iterador++) {
						    sucursal += cadena[iterador].substring(0, 3)+ " ";
						}						
						meses.push (sucursal +"-"+departamento);						
						
						cantidad.push (parseInt(dados[i][j].total));						
					}
				 }
						
				var areaChartData = {
				  labels  : meses,
				  datasets: [
					{
					  label               : 'FALTAS',
					  backgroundColor     : 'rgba(210, 214, 222, 1)',
					  borderColor         : 'rgba(210, 214, 222, 1)',
					  pointRadius         : false,
					  pointColor          : 'rgba(210, 214, 222, 1)',
					  pointStrokeColor    : '#c1c7d1',
					  pointHighlightFill  : '#fff',
					  pointHighlightStroke: 'rgba(220,220,220,1)',
					  data                : cantidad
					}
				  ]
				}	  
				
				
				var barChartCanvas = $('#barChart').get(0).getContext('2d');
 		 
			 
			 
				var barChartData = jQuery.extend(true, {}, areaChartData)
				var temp0 = areaChartData.datasets[0]
				barChartData.datasets[0] = temp0

				var barChartOptions = {
				  responsive              : true,
				  maintainAspectRatio     : false,
				  datasetFill             : false			  
				}
		 	    
				var barChart = new Chart(barChartCanvas, {
				  type: 'bar', 
				  data: barChartData,
				  options: barChartOptions
				})

			
				
			}
		});		
			
	}

     $("#btnInforme").click(function(){
        $('#modal-usuario').modal("toggle");
		$('.div-response').html('<form action="exportar.pdf.inc.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtSucursal" name="txtSucursal" value="'+$("#txtSucursal").val()+'" >'+	
		'<input type="text" class="form-control" id="txtDepartamento" name="txtDepartamento" value="'+$("#txtDepartamento").val()+'" >'+		
		'<input type="text" class="form-control" id="txtFecha_inicio" name="txtFecha_inicio" value="'+$("#txtFecha_inicio").val()+'" >'+	
		'<input type="text" class="form-control" id="txtFecha_termino" name="txtFecha_termino" value="'+$("#txtFecha_termino").val()+'" >'+				
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');				
	});
	
	$('#modal-default').on('hidden.bs.modal', function () {
		$('.div-response').empty();
		$('.div-response').html('<form action="../inc/loading.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'</form>');			
		document.forms['form'].submit();		 
	});		
	

});
</script>
</body>
</html>
