<?php
/** Incluir la libreria PHPExcel */
require('../librerias/PHPExcel/Classes/PHPExcel.php');
/** Incluir función encargada de extraer la información de la base de datos */
// Crea un nuevo objeto PHPExcel
$objPHPExcel = new PHPExcel();


// Establecer propiedades
$objPHPExcel->
getProperties()
->setCreator("POWERTIME")
->setLastModifiedBy("POWERTIME")
->setTitle("Reporte POWERTIME")
->setSubject("Resumen POWERTIME")
->setDescription("Documento generado POWERTIME, Reporte registros base de datos")
->setKeywords("Reportes POWERTIME")
->setCategory("Reportes");


$url = 'http://200.24.13.60/~program1/power-time-api/public/informemarcadepartamentomanual';
$ch = curl_init($url); //create a new cURL resource
$payload = json_encode(array(
	'fecha_inicio' => date("Y-m-d", strtotime($_POST["fecha_inicio"])),
	'fecha_termino' => date("Y-m-d", strtotime($_POST["fecha_termino"])),
	'id_departamento' => $_POST["id_departamento"],
));
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);//attach encoded JSON string to the POST fields
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
$result = curl_exec($ch); //execute the POST request
$array = json_decode($result);




// Agregar Informacion
$objPHPExcel->setActiveSheetIndex(0)
->setCellValue('A1', 'FECHA')
->setCellValue('B1', 'HORA')
->setCellValue('C1', 'TIPO MARCA')
->setCellValue('D1', 'RUT')
->setCellValue('E1', 'NOMBRE')
->setCellValue('F1', 'ESTADO');
// Empezamos agregar datos desde la 3er fila
$fila = 2;

foreach ($array[0] as $row) {
 
	$objPHPExcel->setActiveSheetIndex(0)
	->setCellValue('A'. $fila,  $row->fecha)
	->setCellValue('A'. $fila,  $row->fecha)
	->setCellValue('B'. $fila,  $row->hora)
	->setCellValue('C'. $fila,  utf8_decode($row->tipomarca))
	->setCellValue('D'. $fila,  utf8_decode($row->rut))
	->setCellValue('E'. $fila,  utf8_decode($row->nombre) ." ".utf8_decode($row->apellido))
	->setCellValue('F'. $fila,  utf8_decode($row->estado));	
 
	$fila++;	
}

// Renombrar Hoja
$objPHPExcel->getActiveSheet()->setTitle('Listado General');
// Establecer la hoja activa, para que cuando se abra el documento se muestre primero.
$objPHPExcel->setActiveSheetIndex(0);

// Se modifican los encabezados del HTTP para indicar que se envia un archivo de Excel.
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="reporte.xlsx"');
header('Cache-Control: max-age=0');

$objWriter=PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');
//$objWriter=PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel5');
$objWriter->save('php://output');
exit;
?>
