<?php include_once("../lib/control.seguridad.php"); ?>		
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">   
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />    
  <style>
	  #example{
		  font-size:10px;
	  }
	  .form-text{
		  font-size:12px;	  
	  }
       .dataTables_wrapper { font-size: 10px }	     
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <h4>Marcajes Reloj Control</h4>
			<span class="form-text h6">Este m&oacute;dulo permite hacer consultas directas a API de relojcontrol</span>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
	  <form method="POST">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
 			  <div class="form-row align-items-center">
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha</div>
					</div>
					<input type="text" class="form-control" id="txtFecha" name="txtFecha" value="<?php echo date("Y-m-d") ?>" readonly >
				  </div>
				</div>		
				<div class="col-md-2">
				  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnBuscar">Buscar</button>
				</div>	
				<div class="col-md-2">
				  <button type="button" class="btn btn-danger mb-2 btn-sm" id="btnInforme">Informe PDF</button>
				</div>					
			  </div>             
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                <tr>	
                  <th>FECHA</th>	
                  <th>HORA</th>						
                  <th>RUT</th>	
                  <th>NOMBRE</th>		
                  <th>DEPARTAMENTO</th>	
                  <th>SUCURSAL</th>					  
                  <th>TIPO MARCAJE</th>					  
                </tr> 
                </thead>
              </table>
			  
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
	</form>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <div class="div-response"></div>
  <?php include_once("../inc/footer.php"); ?>
  
<div class="modal" tabindex="-1" role="dialog"  id="modal-default">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Visor de Documentos</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body modal-body-informe">
        <iframe name="iframe3" width="100%" height="100%" src="../inc/loading.php"></iframe>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>  

<div class="modal" tabindex="-1" role="dialog"  id="modal-loading">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Powertime</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <img class="img-fluid" src="../img/loading.gif">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>  
    
 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../plugins/jQueryUI/jquery-ui.js"></script> 
<script>
  $(function () { 
  
    $(".modal-body-informe").height(parseInt(screen.height) -400);  
	
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 		  
    });
	
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	 
	 $("#txtFecha").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",		
	 }) 
	 
	$("#btnBuscar").click(function(){
		listarRegistroMarcaje(); 
	});

	function listarRegistroMarcaje(){
		$('#example').dataTable().fnClearTable();
		var parametros = {
			"txtFecha" : $("#txtFecha").val()
		};		
		$.ajax({
			type:'POST',
			dataType: "json",
			url: "listado.inc.php",		
			data : parametros,
			beforeSend: function() {
				$('#modal-loading').modal('show');
			},			
			success: function(dados)
			{			
				$('#example').dataTable().fnClearTable();				
				 for (i=0;i<dados.length;i++){				  
					  $('#example').dataTable().fnAddData( [						  
						dados[i].fecha,
						dados[i].hora,
						dados[i].rut,						
						dados[i].nombre +" "+dados[i].apellido,						
						dados[i].departamento,
						dados[i].sucursal,
						dados[i].tipo_marcaje					
					  ]);				
				}
				$('#modal-loading').modal('toggle');
			}
		});

	}	 
	 
	$("#btnInforme").click(function(){

		$('.div-response').html('<form action="exportar.pdf.inc.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtFecha" name="txtFecha" value="'+$("#txtFecha").val()+'" >'+	
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');				
	});
		
	
	$('#modal-default').on('hidden.bs.modal', function () {
		$('.div-response').empty();
		$('.div-response').html('<form action="../inc/loading.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'</form>');			
		document.forms['form'].submit();		 
	});		 
	
});
</script>
</body>
</html>
