<?php 
include_once("../lib/control.seguridad.php"); 		
?>			
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">  
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />    
  
  <style>
  #example{
	  font-size:11px;
  }
      .dataTables_wrapper { font-size: 10px }	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Sincronizar Reloj Control</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
	<form method="POST">
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
 			  <div class="form-row align-items-center">
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha</div>
					</div>
					<input type="text" class="form-control" id="txtFecha" name="txtFecha" value="<?php echo date("Y-m-d") ?>" readonly >
				  </div>
				</div>		
				<div class="col-md-2">
				  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnBuscar">Buscar</button>
				</div>		
			  </div>  
            </div>
            <!-- /.card-header -->
            <div class="card-body">
				<table id="example" class="table table-bordered table-striped">
					<thead>
						<tr>	
							<th>FECHA</th>	
							<th>HORA</th>						
							<th>RUT</th>	
							<th>NOMBRE</th>	
							<th>APELLIDO</th>			
							<th>&Aacute;REA</th>	
							<th>CENTRO</th>					  
							<th>TIPO MARCAJE</th>	
							<th>ACCI&Oacute;N</th>					  
						</tr> 
					</thead>
					<tbody>
					</tbody>
				</table>
			  <div class="div-response"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
	</form>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
</div>
<!-- ./wrapper -->


<!-- Modal -->
<div class="modal fade" id="modalLoading" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Cargando Listado de Marcajes</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <img src="../img/loading.gif" style="height:350px;" />
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i class="fas fa-backspace"></i> Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../plugins/jQueryUI/jquery-ui.js"></script> 

<script>
  $(function () { 
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	
    });
	
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	 
	 $("#txtFecha").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",		
	 }) 	

	const listado = async() =>{
		var formData = new FormData();
		formData.append('txtFecha', $("#txtFecha").val());

		$("#modalLoading").modal("show");
		const resultado = await fetch('http://200.24.13.60/~program1/powertime/marcaje_reloj_control/index.inc.php',{
			method: "POST",
			body: formData, 
		}).finally(()=>{
			$("#modalLoading").modal("toggle");
		});
 
		const data = await resultado.json();
		console.log(data);
		$('#example').dataTable().fnClearTable();
		const map = await data.map((res) =>{
			$('#example').dataTable().fnAddData( [				  
				res.fecha,
				res.hora,					
				res.rut,
				res.nombres,	
				res.apellidos,		
				res.departamento,
				res.sucursal,				  
				res.tipo,
				res.mensaje
			]);        
		}) 		
	}
	
	listado();
	$("#btnBuscar").click(function(){
		listado();
	});	
	
	
});
</script>
</body>
</html>
