<?php include_once("../lib/control.seguridad.php"); ?>
<?php
	$fecha_inicio = date('d-m-Y', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('d-m-Y', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />  

   <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />   
  <style>
      #example{
    	  font-size:10px;
      }
      .icon{
          font-size:16px;         
      }
      .dataTables_wrapper { font-size: 10px }
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-11">
            <h4>Permisos y Gesti&oacute;n de Ausencias</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
        
        <div class="row">
            
          <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
              <span class="info-box-icon bg-success elevation-1"><a href="../permiso/index.php"><i class="fas fa-upload"></a></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Permisos</span>
                <span class="info-box-number">Nuevo Permiso</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>            
            
          <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
              <span id="btnPendiente" class="info-box-icon bg-warning elevation-1"><i class="fas fa-edit"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Permisos</span>
                <span class="info-box-number">Pendientes</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->

          <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
              <span id="btnAprobado" class="info-box-icon bg-info elevation-1"><i class="fas fa-thumbs-up"></i></span> 

              <div class="info-box-content">
                <span class="info-box-text">Permisos</span>
                <span class="info-box-number">Ingresados</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          
          <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
              <span class="info-box-icon bg-danger elevation-1"><a href="../faltamanual/index.php"><i class="fas fa-calendar"></a></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Ingreso de</span>
                <span class="info-box-number">Ausencias</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>              
          
        </div>
        <!-- /.row -->        
        
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			  <div class="form-row align-items-center">
			    <div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Centro</div>
					</div>
					<select class="form-control" id="txtDepartamento"> </select>
				  </div>							
				</div>				  
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Inicio</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha T&eacute;rmino</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
				  </div>
				</div>				
				<div class="col-md-3">
				  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnBuscar">Buscar</button>
				  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnImprimir">Imprimir Informe</button>
				</div>					
			  </div>			  
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                
				<ul class="nav nav-tabs ml-auto p-2" id="menu"> 
				  <li class="nav-item" id="li-pendiente">
					<a class="nav-link nav-marcaje active" id="nav-pendiente" href="#permiso-pendiente" data-toggle="tab">Permisos Pendientes</a> 
				  </li>
				  <li class="nav-item d-none" id="li-aprobado">
					<a class="nav-link nav-permiso" id="nav-aprobado" href="#permiso-aprobado" data-toggle="tab">Permisos Ingresados</a>
				  </li>	
				  <li class="nav-item" id="li-aprobado">
					<a class="nav-link nav-hora" id="nav-aprobado" href="#hora-extra" data-toggle="tab">Horas Extraordinarias</a>
				  </li>					  			  
				</ul>	
				
				<div class="tab-content p-0">
				  <div class="tab-pane active" id="permiso-pendiente">
	  				<div class="row mt-2">
	  					<div class="col-md-12">
						  <table id="example" class="table table-bordered table-striped"> 
								<thead>
									<tr>	
										<th>FOLIO</th>		
										<th>FECHA INICIO</th>				
										<th>FECHA T&Eacute;RMINO</th>	
										<th>D&Iacute;AS</th>					  
										<th>TIPO DE PERMISO</th>	
										<th>ESTADO</th>			
										<th>RUT</th>					  
										<th>TRABAJADOR</th>	
										<th>&Aacute;REA</th>	
										<th>CENTRO</th>	
										<th class="text-center icon"><i class="far fa-edit"></i></th>	
										<th class="text-center icon"><i class="far fa-thumbs-up"></i></th>                          
										<th class="text-center icon"><i class="far fa-trash-alt"></i></th>	
										<th class="text-center icon"><i class="far fa-file"></i></th>	                  
									</tr>
								</thead>			
							</table>	
						</div>
					</div>
				  </div>
				  <!-- <div class="tab-pane d-none" id="permiso-aprobado">
					  <div class="row mt-2">
	  					<div class="col-md-12">
						  <table id="example2" class="table table-bordered table-striped"> 
								<thead>
									<tr>	
										<th>FOLIO</th>			
										<th>FECHA INICIO</th>				
										<th>FECHA T&Eacute;RMINO</th>	
										<th>D&Iacute;AS</th>			  
										<th>TIPO DE PERMISO</th>	
										<th>ESTADO</th>			
										<th>RUT</th>					  
										<th>TRABAJADOR</th>	
										<th>&Aacute;REA</th>	
										<th>CENTRO</th>	
										<th class="text-center icon"><i class="far fa-file"></i></th>	                  
									</tr>
								</thead>			
							</table>
						</div>
					  </div>					  
				  </div> -->
				  <div class="tab-pane" id="hora-extra">		
					  <div class="row mt-2">
	  					<div class="col-md-12">
							<table id="exampleHE" class="table table-bordered table-striped">
								<thead>
									<tr>			
										<th>FECHA</th>				
										<th>CANTIDAD APROBADA</th>				
										<th>TRABAJADOR</th>	
										<th>TURNO</th>	
										<th>CARGO</th>					  
										<th></th>					  
									</tr>
								</thead>			
							</table>	
						</div>
					  </div>				  			  
				  </div> 				   					  
				</div>	
                
			  <div class="div-response"></div>
			  <input type="hidden" class="form-control control-text" id="txtId_autoriza" value="<?php echo $_SESSION['LOGIN']['CODIGO']; ?>">
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
  <div id="modal-delete" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<p>&iquest; Desea Anular Permiso ?</p>
			  <div class="form-group">
				<textarea class="form-control control-text" id="txtObservacion" rows="5"></textarea>
				<small class="form-text text-muted">Observaci&oacute;nes</small>
			  </div>				
		  	  <button type="button" class="btn btn-danger" id="btn-anular">Anular Permiso</button>					
		  </div>
		  <div class="modal-footer">
		    <input type="hidden" class="form-control control-text" id="txtId_autoriza" value="<?php echo $_SESSION['LOGIN']['CODIGO'] ?>">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  
	
  <div id="modal-aprobar" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<p>&iquest; Desea Enviar al Administrador el Permiso ?</p>
			  <div class="form-group">
				<textarea class="form-control control-text" id="txtObservacion_apruebo" rows="5"></textarea>
				<small class="form-text text-muted">Observaci&oacute;nes</small>
			  </div>				
		  	  <button type="button" class="btn btn-success" id="btn-aprobar-per">Enviar</button>					
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  	
	
	<div class="modal" tabindex="-1" role="dialog"  id="modal-default">
	  <div class="modal-dialog modal-xl" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">Visor de Documentos</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body modal-body-documento">
			<iframe name="iframe3" width="100%" height="100%" src="../inc/loading.php"></iframe>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
		  </div>
		</div>
	  </div>
	</div>	

	<div class="modal" tabindex="-1" role="dialog"  id="modal-default2">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">Powertime</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<label>&iquest; Desea Enviar Permiso a Firma Electr&oacute;nica ?</label>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-success btn-sm" id="btnEnviarElectronico">Enviar Permiso</button>		  
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
		  </div>
		</div>
	  </div>
	</div>		

	<div class="modal" tabindex="-1" role="dialog"  id="modal-default3">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">Powertime</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<label id="mensajeAcepta"> </label>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
		  </div>
		</div>
	  </div>
	</div>	

	<div class="modal" tabindex="-1" role="dialog"  id="modal-default4">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">Powertime</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center" id="contenidodelmodal">
			<label>&iquest; Desea Enviar Hora Extraordinaria a Firma Electr&oacute;nica ?</label>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-success btn-sm" id="btnEnviarElectronicoHora">Enviar Permiso</button>		  
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
		  </div>
		</div>
	  </div>
	</div>			
 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../plugins/jQueryUI/jquery-ui.js"></script>
<script src="../plugins/toastr/toastr.js"></script>

<script>
  $(function () { 

    $(".modal-body-documento").height(parseInt(screen.height) -400);

    $(document).bind("contextmenu",function(e){
      return false;
    });	  
	  
    $('#txtObservacion').keyup(function(){
        $(this).val($(this).val().toUpperCase());
    });	 	

    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });

    $('#exampleHE').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });
    
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });    
	
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 }) 		
	
	$("#btnBuscar").click(function(){
		listarRegistro();
	});
	$("#txtDepartamento").change(function () {
		listarRegistro();
    });	
    
	$("#btnPendiente").click(function () {
	    $("#permiso-pendiente").removeClass("d-none"); 
	    $("#permiso-aprobado").addClass("d-none");
	    $("#li-pendiente").removeClass("d-none");  
	    $("#li-aprobado").addClass("d-none");
	    
	    $("#permiso-pendiente").addClass("active"); 
	    $("#permiso-aprobado").removeClass("active");	    
	    $("#nav-pendiente").addClass("active");
	    $("#nav-aprobado").removeClass("active");		 
    }); 
	$("#btnAprobado").click(function () {
	    $("#permiso-pendiente").addClass("d-none"); 
	    $("#permiso-aprobado").removeClass("d-none");	
	    $("#li-pendiente").addClass("d-none"); 
	    $("#li-aprobado").removeClass("d-none");
	    
	    $("#permiso-pendiente").removeClass("active"); 
	    $("#permiso-aprobado").addClass("active");	 	    
	    $("#nav-pendiente").removeClass("active");
	    $("#nav-aprobado").addClass("active");		    
    });
		
	listarRegistroDep();
	function listarRegistroDep(){

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>" + "/public/departamentopersona",
			data : JSON.stringify({
				id_persona:$("#txtId_autoriza").val()					
			}),			
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){					

						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id_departamento,
							text : dados[i][j].sucursal + " (" +dados[i][j].departamento +" )"
						}));
					}
				}
				listarRegistro();
			}
		});

	}	
		
	listarRegistro();
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>" + "/public/permisoestadodepto",	
			data : JSON.stringify({
				fecha_inicio: invertirCadena($("#txtFecha_inicio").val()),
				fecha_termino: invertirCadena($("#txtFecha_termino").val()),		
				id_departamento: parseInt($("#txtDepartamento").val()),
				id_estado: 1				
			}),				
			success: function(dados)
			{
                console.log(JSON.stringify({
				fecha_inicio: invertirCadena($("#txtFecha_inicio").val()),
				fecha_termino: invertirCadena($("#txtFecha_termino").val()),		
				id_departamento: parseInt($("#txtDepartamento").val()),
				id_estado: 1				
			}));
				 var dias = ["Lun", "Mar", "Mie", "Jue", "Vie", "Sab", "Dom"];
				
                 console.log(dados);
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  var boton = "<button type='button' class='btn btn-warning btn-xs btn-editar'>Editar</button>";
					  var boton2 = "<button type='button' class='btn btn-danger btn-xs btn-eliminar'>Anular</button>";
					  var boton3 = "<button type='button' class='btn btn-info btn-xs btn-ver-permiso'>Ver Permiso</button>";
					  //var boton4 = "<button type='button' class='btn btn-success btn-xs btn-aprobar'>Enviar a Administrador</button>";					  
					  

					  var boton4  = "<button type='button' class='btn btn-primary btn-xs btn-permiso-digital'>Ver Permiso ACEPTA</button>";
					  if(dados[i][j].pdfacepta =="" || dados[i][j].pdfacepta == null){

						if(dados[i][j].estado != "ANULADO"){
						    boton4  = "<button type='button' class='btn btn-success btn-xs btn-enviar-digital'>Enviar a Firma</button>";						  
						}

					  }

					  var fecha_inicio  = new Date(dados[i][j].fecha_inicio);
					  var fecha_termino  = new Date(dados[i][j].fecha_termino);
					  
					  $('#example').dataTable().fnAddData( [
						dados[i][j].id,
						convertDateFormat(dados[i][j].fecha_inicio),	
						convertDateFormat(dados[i][j].fecha_termino),
						dados[i][j].total,						
						dados[i][j].tipo,
						dados[i][j].estado,							
						dados[i][j].rut,								
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].sucursal + "<input type='hidden' value ='"+dados[i][j].pdfacepta+"' />",			
						dados[i][j].departamento + "<input type='hidden' value ='"+dados[i][j].formato+"' />",			
						boton + "<input type='hidden' value ='"+dados[i][j].id+"' />",
						boton4,						
						boton2,
						boton3 
					  ]);
					}
				}
			}
		});

        /*************************************************************/
        
		/* $('#example2').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php //include_once('../inc/api_cred.php'); echo $apiUrl; ?>" + "/public/permisoestadodepto",	
			data : JSON.stringify({
				fecha_inicio: invertirCadena($("#txtFecha_inicio").val()),
				fecha_termino: invertirCadena($("#txtFecha_termino").val()),		
				id_departamento: $("#txtDepartamento").val(),
				id_estado: 0				
			}),				
			success: function(dados)
			{
				 var dias = ["Lun", "Mar", "Mie", "Jue", "Vie", "Sab", "Dom"];
				
                 console.log(dados);
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  var boton = "<button type='button' class='btn btn-info btn-xs btn-ver-permiso'>Ver Permiso</button>";
					  
					  var fecha_inicio  = new Date(dados[i][j].fecha_inicio);
					  var fecha_termino  = new Date(dados[i][j].fecha_termino);
					  
					  $('#example2').dataTable().fnAddData( [
						dados[i][j].id,
						convertDateFormat(dados[i][j].fecha_inicio),	
						convertDateFormat(dados[i][j].fecha_termino),
						dados[i][j].total,						
						dados[i][j].tipo,
						dados[i][j].estado,							
						dados[i][j].rut,								
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].sucursal,	
						dados[i][j].departamento + "<input type='hidden' value ='"+dados[i][j].formato+"' />",		
						boton + "<input type='hidden' value ='"+dados[i][j].id+"' />",
					  ]);
					}
				}
			}
		});  */
		
		/******************************************************** */

		$('#exampleHE').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/informehoraextradepartamento",	
			data : JSON.stringify({
				fecha_inicio: invertirCadena($("#txtFecha_inicio").val()),
				fecha_termino: invertirCadena($("#txtFecha_termino").val()),
				departamento: $("#txtDepartamento").val()							
			}),						
			success: function(dados)
			{
				$('#exampleHE').dataTable().fnClearTable();
				
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					var boton  = "<button type='button' class='btn btn-primary btn-xs btn-permiso-digital'>Ver Permiso ACEPTA</button>";
					  if(dados[i][j].pdfacepta =="" || dados[i][j].pdfacepta == null){

						if(dados[i][j].estado != "ANULADO"){
						    boton  = "<button type='button' class='btn btn-success btn-xs btn-enviar-digital'>Enviar a Firma</button>";						  
						}

					  }

					  var boton3 = "<button type='button' class='btn btn-info btn-xs btn-ver-permiso''>Ver Documento</button>";
					  $('#exampleHE').dataTable().fnAddData( [
						dados[i][j].fecha,	
						dados[i][j].cantidad,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].turno,	
						dados[i][j].cargo + "<input type='hidden' value ='"+dados[i][j].pdfacepta+"' />",							
						boton +" "+boton3 + "<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					}
				}
			}
		});

	}

	var idPermiso;
	var btnClicked;
	$("#example").on('click','.btn-enviar-digital', function() {
		idPermiso = $(this).parents("tr").find("td:eq(10)").find("input").val();
		btnClicked = $(this);
		$('#modal-default4').modal('show');		
	});
	
    $("#btnEnviarElectronicoHora").click(function(){
        btnClicked.attr("disabled", "true");
		$.ajax({
			type:'POST',
			dataType: "json",
			url: "enviarAcepta.php",
			data : {
				id:idPermiso,				
			},
			success: function(response) {
				enviarElectronico(response);
			},
			error: function (request, status, error) {
				alert(request.responseText);
			}				
		})		
	});	
	
	function enviarElectronico(documento){
		$("#modal-default4").modal("toggle");
		$.ajax({
			type:'POST',
			dataType: "json",
			url: documento,
			data : {
				txtId_permiso:idPermiso,				
			},
			success: function(response) {

			   	
				if(parseInt(response) > 0){
				    $("#mensajeAcepta").html("Enviado a Firma Electr&oacute;nica");
				    $("#modal-default3").modal("show");
				}else{
				    $("#mensajeAcepta").html("Problema Enviando a Firma Electr&oacute;nica");
				    $("#modal-default3").modal("show");				    
				}
				listarRegistro();
			},
			error: function (request, status, error) {
				alert(request.responseText);
				listarRegistro();
			}			
		})			
	}	

	$("#example").on('click','.btn-permiso-digital', function() {

		$('.div-response').html('<form action="permisoAcepta.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="codigo" name="codigo" value="'+$(this).parents("tr").find("td:eq(8)").find("input").val()+'" >'+
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');		
	});	
	
	/********************************** */

	var idHoraextra;
	$("#exampleHE").on('click','.btn-enviar-digital', function() {
		idHoraextra = $(this).parents("tr").find("td:eq(5)").find("input").val();		
		$('#modal-default2').modal('show');		
	});
	
    $("#btnEnviarElectronico").click(function(){
		$.ajax({
			type:'POST',
			dataType: "json",
			url: "enviarAceptaHora.php",
			data : {
				id:idHoraextra,				
			},
			success: function(response) {

				enviarElectronicoHora(response);
			},
			error: function (request, status, error) {
				alert(request.responseText);
			}				
		})		
	});	
	
	function enviarElectronicoHora(documento){
		$('#modal-default2').modal('toggle');	
		$("#mensajeAcepta").html("Espere mientras se envía documento a portal de Firma Electrónica");
		$("#modal-default3").modal("show");
		$.ajax({
			type:'POST',
			dataType: "json",
			url: documento,
			data : {
				txtId_permiso:idHoraextra,				
			},
			success: function(response) {
				$("#modal-default3").modal("toggle");
				if(parseInt(response) > 0){
				    $("#mensajeAcepta").html("Enviado a Firma Electr&oacute;nica");
				    $("#modal-default3").modal("show");
				}else{
				    $("#mensajeAcepta").html("Problema Enviando a Firma Electr&oacute;nica");
				    $("#modal-default3").modal("show");				    
				}
				listarRegistro();
			},
			error: function (request, status, error) {
				alert(request.responseText);
			}			
		})			
	}	

	$("#exampleHE").on('click','.btn-permiso-digital', function() {

		$('.div-response').html('<form action="horaextraAcepta.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="codigo" name="codigo" value="'+$(this).parents("tr").find("td:eq(4)").find("input").val()+'" >'+
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');		
	});	

	$("#exampleHE").on('click','.btn-ver-permiso', function() {
		$('.div-response').html('<form action="../formatopermiso/horaextra.pdf.inc.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtId_permiso" name="txtId_permiso" value="'+$(this).parents("tr").find("td:eq(5)").find("input").val()+'" >'+
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');		
	});		

	/********************************* */
	
	$("#btnImprimir").click(function(){
		$('.div-response').html('<form action="../permiso/informe.general.permiso.pdf.inc.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtFecha_inicio" name="txtFecha_inicio" value="'+invertirCadena($("#txtFecha_inicio").val())+'" >'+
		'<input type="text" class="form-control" id="txtFecha_termino" name="txtFecha_termino" value="'+invertirCadena($("#txtFecha_termino").val())+'" >'+
		'<input type="text" class="form-control" id="txtDepartamento" name="txtDepartamento" value="'+$("#txtDepartamento").val()+'" >'+
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');			
	});
	
	$('#modal-default').on('hidden.bs.modal', function () {
		$('.div-response').empty();
		$('.div-response').html('<form action="../inc/loading.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'</form>');			
		document.forms['form'].submit();		 
	});		
	
	function convertDateFormat(string) {
        var info = string.split('-').reverse().join('-').split('-');
        return info[0]+"-"+info[1]+"-"+info[2];
    }	
	
	
	$("#example").on('click','.btn-ver-permiso', function() {
		$('.div-response').html('<form action="../formatopermiso/'+$(this).parents("tr").find("td:eq(9)").find("input").val()+'"   target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtId_permiso" name="txtId_permiso" value="'+$(this).parents("tr").find("td:eq(10)").find("input").val()+'" >'+
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');		
	});	
	
	$("#example2").on('click','.btn-ver-permiso', function() {
		$('.div-response').html('<form action="../formatopermiso/'+$(this).parents("tr").find("td:eq(9)").find("input").val()+'"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtId_permiso" name="txtId_permiso" value="'+$(this).parents("tr").find("td:eq(10)").find("input").val()+'" >'+
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');		
	});		
	
	$("#example").on('click','.btn-editar', function() {
		var id = $(this).parents("tr").find("td:eq(10)").find("input").val();
		$('.div-response').html('<form action="../permiso/index.php" name="form" method="post" style="display:none;"><input type="text" name="txtId" id="txtId" value="'+ id +'" /></form>');
		document.forms['form'].submit();
	});		
	
	var idPermiso;	
	$("#example").on('click','.btn-eliminar', function() {			
		$('#modal-delete').modal("show");
	    idPermiso = $(this).parents("tr").find("td:eq(10)").find("input").val();
	});	
	
	$("#example").on('click','.btn-aprobar', function() {			
		$('#modal-aprobar').modal("show");
	    idPermiso = $(this).parents("tr").find("td:eq(10)").find("input").val();
	});	
		
	$("#btn-anular").click(function(){
		modificarEstadoPermiso(3, $("#txtObservacion").val());	
	});
	
	$("#btn-aprobar-per").click(function(){
		modificarEstadoPermiso(2, $("#txtObservacion_apruebo").val());	
	});	

	function modificarEstadoPermiso(codigo, obsernacion){
	    if(codigo == 2){
	        $('#modal-aprobar').modal("toggle");	
	    }
	    if(codigo == 3){
	        $('#modal-delete').modal("toggle");
	    }
		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/modificarestadopermiso",
			data : JSON.stringify({
				id:idPermiso,
				id_estado:codigo			
			}),
			success: function(data) {
				if(parseInt(data[0]) == 1){
					listarRegistro();					
					$.ajax({
						type:'POST',
						contentType: 'application/json',
						dataType: "json",
						crossDomain: true,
						headers: {
							'Content-Type': 'application/json'
						},
						url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/ingresarlogpermiso",
						data : JSON.stringify({
							id_permiso:idPermiso,
							id_usuario:$("#txtId_autoriza").val(),	
							observacion: observacion				
						}),
						success: function(data) {
							if(parseInt(data[0]) == 1){
								var mensaje = "Permiso Anulado Exitosamente";
								if(codigo == 2){ mensaje = "Permiso Aprobado Exitosamente"; }
								toastr.success(mensaje, "POWERTIME");
								$("#txtObservacion").val("");
							}
						}
					})						
					
				} else {
					listarRegistro();
				}
			}
		})			
	}	
	
    function invertirCadena(numeros) { 
        return numeros.split('-').reverse().join('-')
    }

	$("#btnNuevo_registro").click(function(){
		window.location="index.php";
	});		
});
</script>
</body>
</html>
