<?php include_once("../lib/control.seguridad.php"); ?>
<?php
	$fecha_inicio = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('Y-m-d', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />   
 
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" /> 
  <style>
  #example{
	  font-size:10px;
  }
  #example2{
	  font-size:10px;
  }  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Permisos Pendientes</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Permisos Pendientes</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			  <div class="form-row align-items-center">
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Inicio</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
				  </div>
				</div>
				<div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Termino</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
				  </div>
				</div>				
				<div class="col-auto">
				  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnBuscar">Buscar</button>
				</div>			
			  </div>			  
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                <tr>			
                  <th>FECHA INICIO</th>				
                  <th>FECHA TERMINO</th>	
                  <th>ESTADO DE PERMISO</th>					  
                  <th>TIPO DE PERMISO</th>				
                  <th>TRABAJADOR</th>	
                  <th></th>					  
                </tr>
                </thead>			
              </table>
			  <div class="div-response"></div>
            </div>
			<div class="card-footer">
				<div class="row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Cantidad</div>
						</div>
						<input type="text" class="form-control" id="txtCantidad_permiso" value="0" readonly >
					  </div>
					</div>					
				</div>
			</div>			
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div id="modal-trasabilidad" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog  modal-lg" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">	
              <table id="example2" class="table table-bordered table-striped">
                <thead>
                <tr>			
                  <th>FECHA</th>				
                  <th>HORA</th>	
                  <th>TIPO PERMISO</th>
                  <th>N* PERMISO</th>				  
                  <th>TRABAJADOR</th>				
                  <th>AUTORIZA</th>	
                  <th>OBSERVACION</th>					  					  
                </tr>
                </thead>			
              </table>		  
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  

 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../plugins/jQueryUI/jquery-ui.js"></script>

<script src="../plugins/toastr/toastr.js"></script>
<script>
  $(function () { 
  
    $(document).bind("contextmenu",function(e){
      return false;
    });	  
	  
    $('#txtObservacion').keyup(function(){
        $(this).val($(this).val().toUpperCase());
    });	 	
	
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "autoWidth": false,
    });
	
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "autoWidth": false,
    });	
	
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 }) 		
	
	$("#btnBuscar").click(function(){
		listarRegistro();
	});
		
	listarRegistro();
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/permisoestado",	
			data : JSON.stringify({
				fecha_inicio: $("#txtFecha_inicio").val(),
				fecha_termino: $("#txtFecha_termino").val(),	
				id_estado: 2									
			}),				
			success: function(dados)
			{
				$('#example').dataTable().fnClearTable();
				$("#txtCantidad_permiso").val(0);
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  var boton2 = "<button type='button' class='btn btn-info btn-xs btn-eliminar'>Ver Trasabilidad</button>";
					  $('#example').dataTable().fnAddData( [
						dados[i][j].fecha_inicio,	
						dados[i][j].fecha_termino,
						dados[i][j].estado,
						dados[i][j].tipo,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
					    boton2 + "<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					  $("#txtCantidad_permiso").val(parseInt($("#txtCantidad_permiso").val()) +1)
					}
				}
			}
		});

	}
	
	$("#example").on('click','.btn-eliminar', function() {			
		$('#modal-trasabilidad').modal("show");	
        $('#example2').dataTable().fnClearTable();
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/listartrasabilidadpermiso",	
			data : JSON.stringify({
				id_permiso: $(this).parents("tr").find("td:eq(5)").find("input").val(),							
			}),				
			success: function(dados)
			{
				$('#example2').dataTable().fnClearTable();
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
					  $('#example2').dataTable().fnAddData( [
						dados[i][j].fecha,	
						dados[i][j].hora,
						dados[i][j].tipo,
						dados[i][j].id,						
						dados[i][j].trabajador,
						dados[i][j].autoriza,
						dados[i][j].observacion
					  ]);
					}
				}
			}
		});
		
	});	
		


});
</script>
</body>
</html>
