<?php
require_once ('../librerias/dompdf/autoload.inc.php');
use Dompdf\Dompdf;

setlocale(LC_TIME, "spanish");
	
$url = 'http://200.24.13.60/~program1/power-time-api/public/permisoestadodepto';
$ch = curl_init($url); //create a new cURL resource
$payload = json_encode(array(
	'fecha_inicio' => date("Y-m-d", strtotime($_POST["fecha_inicio"])),
	'fecha_termino' => date("Y-m-d", strtotime($_POST["fecha_termino"])),
	'id_departamento' => $_POST["id_departamento"],
	'id_estado' => $_POST["id_estado"]	
));
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);//attach encoded JSON string to the POST fields
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
$result = curl_exec($ch); //execute the POST request
$array = json_decode($result);

$tbl_html = "";
foreach ($array[0] as $row) {
	
	$fecha_inicio = date("d-m", strtotime($row->fecha_inicio));
	$fecha_termino = date("d-m", strtotime($row->fecha_termino));	
	
	$tbl_html .= "<tr>";
	$tbl_html .= "<td>". substr(strftime("%A", strtotime($row->fecha_inicio)), 0, 3) ." ".$fecha_inicio ."</td>";
	$tbl_html .= "<td>". substr(strftime("%A", strtotime($row->fecha_termino)), 0, 3) ." ".$fecha_termino ."</td>";
	$tbl_html .= "<td>".utf8_decode($row->estado) ."</td>";
	$tbl_html .= "<td>".utf8_decode($row->tipo) ."</td>";
	$tbl_html .= "<td>".utf8_decode($row->nombre) ." ".utf8_decode($row->apellido) ."</td>";
	$tbl_html .= "</tr>";	
}

curl_close($ch); 

function cortarCadena($hora){	
	if($hora != null) { $hora = str_replace("-","", $hora); $hora = substr($hora, 0, 5); return $hora; } else return $hora;
}	

/*****************************************************/

$ch2 = curl_init('http://200.24.13.60/~program1/power-time-api/public/obtenerdepartamento'); //create a new cURL resource
$payload2 = json_encode(array('id' => $_POST["id_departamento"]));
curl_setopt($ch2, CURLOPT_POSTFIELDS, $payload2);//attach encoded JSON string to the POST fields
curl_setopt($ch2, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
$result2 = curl_exec($ch2); //execute the POST request
$array2 = json_decode($result2);

$departamento = utf8_decode($array2[0]->descripcion);			

curl_close($ch2); 
		
$estado = "TODOS";		
if($_POST["id_estado"] > 0){		

	$ch3 = curl_init('http://200.24.13.60/~program1/power-time-api/public/obtenerpermisoestado'); //create a new cURL resource
	$payload3 = json_encode(array('id' => $_POST["id_estado"]));
	curl_setopt($ch3, CURLOPT_POSTFIELDS, $payload3);//attach encoded JSON string to the POST fields
	curl_setopt($ch3, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
	curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
	$result3 = curl_exec($ch3); //execute the POST request
	$array3 = json_decode($result3);

	$estado = utf8_decode($array3[0]->descripcion);			

	curl_close($ch3); 

}

$html = '
<style>
body{
	font-size:13px;
}
.tb-listado table {
  border: 1px solid black;
}
.tb-listado th {
  text-align: center;
}
.tb-listado th {
  background-color: #cccccc;
  color: #000000;
}
.tb-listado tr:nth-child(even) {background-color: #f2f2f2;}
</style>

    <div>
		<img src="../img/002.png" />	
	    <center><h4 style="font-size:16px;">INFORME DE PERMISOS</h4></center>
		<table style="width:100%;">
			<tr>
				<td>
					<table style="width:100%;">
						<tr>
							<td style="width:15%"><b>COMPA&Ntilde;IA :</b></td>
							<td style="width:50%"> CORP MUNICIPAL PARA EL DESARROLLO SOCIAL</td>
							<td style="width:20%"> <b>FECHA INICIO :</b> '.date("d-m-Y", strtotime($_POST["fecha_inicio"])).'</td>							
						</tr>
						<tr>
							<td style="width:15%"><b>RUT :</b></td>
							<td style="width:50%"> 70.983.600-5</td>
							<td style="width:20%"> <b>FECHA TERMINO :</b> '.date("d-m-Y", strtotime($_POST["fecha_termino"])).'</td>								
						</tr>
						<tr>
							<td style="width:15%"><b>DEPARTAMENTO :</b></td>
							<td style="width:50%"> '.$departamento.'</td>
							<td style="width:20%"> </td>								
						</tr>	
						<tr>
							<td style="width:15%"><b>ESTADO :</b></td>
							<td style="width:50%"> '.$estado.'</td>
							<td style="width:20%"> </td>								
						</tr>							
					</table>					
				</td>			
			</tr>		
		</table>
	</div>
	
	<div style="margin-top:30px;">
		<table style="width:100%;" class="tb-listado">
			<thead>
				<tr>
					<th>FECHA INICIO</th>
					<th>FECHA TERMINO</th>
					<th>ESTADO</th>
					<th>TIPO DE PERMISO</th>
					<th>TRABAJADOR</th>						
				</tr>
			</thead>
			<tbody>
			'.$tbl_html.'
			</tbody>
		</table>
	</div>

';

$pdf = new DOMPDF();
$pdf->set_paper("A4", "landscape");
$pdf->load_html(utf8_encode($html));
$pdf->render();
$pdf->stream("marcajes.pdf", array("Attachment" => false));
exit(0);

?>
