<?php include_once("../lib/control.seguridad.php"); ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />  
  <!-- JQUERY TIMEPICKER -->  
  <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">   
  <style>
	  #example{
		  font-size:10px;
	  }
	  label{
		  font-size:13px;
	  } 
	  .ui-timepicker-container {
		  z-index: 3500 !important;
	  }
	  .DatePicker {
		z-index: 100000;
	  }
      .dataTables_wrapper { font-size: 10px }	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Ingreso de Permiso Masivo</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
				<div class="form-row d-none">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Autoriza</div>
						</div>
						<input type="hidden" class="form-control control-text" id="txtId_autoriza" value="<?php echo $_SESSION['LOGIN']['CODIGO'] ?>">
					  </div>
					</div>						
				</div>
				<div class="form-row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Sucursal</div>
						</div>
						<select class="form-control" id="txtSucursal"> </select>
					  </div>
					</div>	
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Departamento</div>
						</div>
						<select class="form-control" id="txtDepartamento">
							<option value="0">Seleccione...</option>
						</select>
					  </div>
					</div>	
					<div class="col-md-4">
						<button type='button' class='btn btn-info btn-sm' id='btnEnviar' name='btnEnviar'>Procesar Elemento(s) Seleccionado(s)</button>
					</div>					
				</div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                <tr>	
                  <th>
				   <div class="input-group input-group-sm">
					   <div class="input-group-prepend">
						   <span class="input-group-text">
							<input type="checkbox" class="btn btn-checkbox-todo">
						   </span>
					   </div>
				   </div>				  
				  </th>				
                  <th>RUT</th>				
                  <th>NOMBRE</th>	
                  <th>TURNO</th>									  
                </tr>
                </thead>			
              </table>
			  <div class="div-response"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div id="modal-confirma" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body">
			<div class="row">
				<div class="col-md-6">
				  <div class="form-group input-group-sm">
					<label>Fecha Inicio :</label>
					<input type="text" class="form-control control-number DatePicker" id="txtFecha_inicio" value="<?php echo date("d-m-Y"); ?>" readonly>
					<small class="form-text text-muted">Fecha de inicio de permiso.</small>
				  </div>	
				  <div class="form-group input-group-sm d-none hora-permiso">
					<label>Hora Inicio :</label>
					<input type="text" class="form-control control-number" id="txtHora_inicio" value="00:00" >
					<small class="form-text text-muted">Hora de inicio de permiso.</small>
				  </div>
				  <p>&iquest; Desea Procesar Listado de Permisos M&aacute;sivo ?<br />
				  Trabajadore(s) seleccionado(s) : (<label class="lblCantidad_trabajador"></label>)</p>				  
				</div>
				<div class="col-md-6">				
				  <div class="form-group input-group-sm">
					<label>Fecha T&eacute;rmino:</label>
					<input type="text" class="form-control control-text DatePicker" id="txtFecha_termino" value="<?php echo date("d-m-Y"); ?>" readonly>
					<small class="form-text text-muted">Fecha de t&eacute;rmino de permiso.</small>
				  </div>			
				  <div class="form-group input-group-sm d-none hora-permiso">
					<label>Hora T&eacute;rmino:</label>
					<input type="text" class="form-control control-text" id="txtHora_termino" value="00:00" >
					<small class="form-text text-muted">Hora de t&eacute;rmino de permiso.</small>
				  </div>
				  <div class="form-group input-group-sm">
					<label>Tipo Permiso :</label>
					<select class="form-control" id="txtTipo_permiso">
						<option value="0">Seleccione...</option>
					</select>
					<small class="form-text text-muted">Seleccione Tipo de permiso a asignar.</small>
				  </div>					  
				</div>				
			</div>			
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
			<button type="button" class="btn btn-info btn-sm" id="btn-confirmar">Confirmar</button>
		  </div>
		</div>
	  </div>
	</div>  

 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script>
 
<link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />
<script src="../plugins/jQueryUI/jquery-ui.js"></script>

<!-- JQUERY TIMEPICKER -->  
<script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>

<script>
  $(function () { 
      
	$("#txtTipo_permiso").change(function() {
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/obtenertipopermiso",
			data : JSON.stringify({
				id:$("#txtTipo_permiso").val(),			
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 200){
					if(parseInt(data[0].hora) === 1) {
						$(".hora-permiso").removeClass("d-none");
					}else{
						$(".hora-permiso").addClass("d-none");						
					}
				}
			}			
		})   
    });	      
  
	  
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 })  	  	  
	    
    /*
	$('#txtHora_inicio').timepicker({ 
		timeFormat: 'HH:mm',
		interval: 30,
		minTime: '00:00',
		maxTime: '23:30',
		dynamic: false,
		dropdown: true,
		scrollbar: true		
	});	
 
	$('#txtHora_termino').timepicker({ 
		timeFormat: 'HH:mm',
		interval: 30,
		minTime: '00:00',
		maxTime: '23:30',
		dynamic: false,
		dropdown: true,
		scrollbar: true		
	});
	
	*/
  
 
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'yy/mm/dd',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	 $("#txtFecha").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: 0 
	 });	
	 
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });
	
	combo();
	function combo(){
		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/tipopermiso",
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtTipo_permiso').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
			}
		});		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/sucursal",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtSucursal').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				departamento();
			}
		});				
	}

	$("#txtSucursal").change(function () {
		departamento();
    });

	function departamento(){
		$('#txtDepartamento').empty();	
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/obtenerdepartamentosucursal",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),								
			}),			
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				listarRegistro();
			}
		});			
	}	
	
	$("#txtDepartamento").change(function () {
		listarRegistro();
    });	

	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/obtenerpersonadepartamentoturno",
			data : JSON.stringify({
				id_departamento: $('#txtDepartamento').val(),								
			}),					
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){		

                    var campo = '<div class="input-group input-group-sm">';
						campo += '<div class="input-group-prepend">';
						campo += '<span class="input-group-text">';
						campo += '<input type="checkbox" class="btn btn-checkbox">';
						campo += '</span>';
						campo += '</div>';
						campo += '</div>';
					
					  $('#example').dataTable().fnAddData( [
					    campo,
						dados[i][j].rut,	
						dados[i][j].nombre +" "+dados[i][j].apellido,
						dados[i][j].turno+ "<input type='hidden' value ='"+dados[i][j].id+"' />",
					  ]);
					}
				}
			}
		});

	}
	
	$("#txtHora").bind('keypress', function(event) {
	  var regex = new RegExp("^[0-9]+$");
	  var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
	  if (!regex.test(key)) {
		event.preventDefault();
		return false;
	  }
	});	  	
	
	$(".btn-checkbox-todo").click(function(){	
		if($(this).is(":checked")){
			jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
				$(this).find("td:eq(0)").find('input[type="checkbox"]').attr("checked", true);
			}); 	
		}else{
			jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
				$(this).find("td:eq(0)").find('input[type="checkbox"]').attr("checked", false);
			}); 			
		}
	});
	
	$("#btnEnviar").click(function(){
		var contador = 0;
		jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
			if($(this).find("td:eq(0)").find('input[type="checkbox"]').is(":checked")){ contador++; }				 
		}); 
		if(contador > 0){
			$('#modal-confirma').modal("show");
			$(".lblCantidad_trabajador").html(contador);		 
		}				 		 				 	
	});
	
	$("#btn-confirmar").click(function(){
        $('#modal-confirma').modal("toggle");		
		var contador = 0;
        var cantidad_trabajador = parseInt($('.lblCantidad_trabajador').html());
		var i= 0;
		jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
			if($(this).find("td:eq(0)").find('input[type="checkbox"]').is(":checked")){ 
			    var id = $(this).find("td:eq(3)").find("input").val();
				$.ajax({
					type:'POST',
					contentType: 'application/json',
					dataType: "json",
					crossDomain: true,
					headers: {
						'Content-Type': 'application/json'
					},
					url: "http://200.24.13.60/~program1/power-time-api/public/ingresarpermiso",
					data : JSON.stringify({
						fecha_inicio:convertDateFormat($("#txtFecha_inicio").val()),
						fecha_termino:convertDateFormat($("#txtFecha_termino").val()),	
						hora_inicio:$("#txtHora_inicio").val(),	
						hora_termino:$("#txtHora_termino").val(),	
						id_tipo_permiso:$("#txtTipo_permiso").val(),							
						id_persona:id,	
					    id_autoriza:$("#txtId_autoriza").val(),	
						observacion:"ASIGNACION DE PERMISO MASIVO"				
					}),
					success: function(data, textStatus, xhr) {
						if(parseInt(xhr.status) == 201){ 
							contador++; i++;
							if(i == cantidad_trabajador) { toastr.success("Se han procesado : ("+contador+") Permisos", "POWERTIME"); }
							$.ajax({
								type:'POST',
								contentType: 'application/json',
								dataType: "json",
								crossDomain: true,
								headers: {
									'Content-Type': 'application/json'
								},
								url: "http://200.24.13.60/~program1/power-time-api/public/ingresarlogpermiso",
								data : JSON.stringify({
									id_permiso:data[0].id,
									id_usuario:$("#txtId_autoriza").val(),	
									observacion:"INGRESO PERMISO, ASIGNACION DE PERMISO MASIVO"				
								}),
								success: function(data, textStatus, xhr) { if(parseInt(xhr.status) == 201){ } }
							})																																	
						}				
					}
				})		 
			}
		}); 

	});	
	
	function convertDateFormat(numeros) {
        return numeros.split('-').reverse().join('-');
    }		
});
</script>
</body>
</html>
