<?php include_once("../lib/control.seguridad.php"); ?>
<?php
	$fecha_inicio = date('d-m-Y', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('d-m-Y', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />   
 
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" /> 
  <style>
	  #example{
		  font-size:10px;	  
	  }
	  #example2{
		  font-size:10px;	  
	  }
	  .content-header h4{ 
		  font-size: 20px
	  }	  
      .dataTables_wrapper { font-size: 10px }	  
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Permisos Pendientes de Aprobaci&oacute;n</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			  <div class="form-row align-items-center">
			    <div class="col-md-4">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Centro</div>
					</div>
					<select class="form-control" id="txtDepartamento"> </select>
				  </div>							
				</div>				  
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Inicio</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
				  </div>
				</div>
				<div class="col-md-3">
				  <div class="input-group mb-2 input-group-sm">
					<div class="input-group-prepend">
					  <div class="input-group-text">Fecha Termino</div>
					</div>
					<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
				  </div>
				</div>				
				<div class="col-md-1">
				  <button type="button" class="btn btn-info mb-2 btn-sm btn-block" id="btnBuscar">Buscar</button>
				</div>	
				<div class="col-md-3">
					<button type='button' class='btn btn-info mb-2 btn-sm' id='btnEnviar' name='btnEnviar'>Procesar Elemento(s) Seleccionado(s)</button>
				</div>					
			  </div>			  
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                <tr>	
                  <th>
				   <div class="input-group input-group-sm">
					   <div class="input-group-prepend">
						   <span class="input-group-text">
							<input type="checkbox" class="btn btn-checkbox-todo">
						   </span>
					   </div>
				   </div>				  
				  </th>					
                  <th>FECHA INICIO</th>				
                  <th>FECHA TERMINO</th>	
                  <th>CANTIDAD DIAS</th>					  
                  <th>ESTADO DE PERMISO</th>					  
                  <th>TIPO DE PERMISO</th>				
                  <th>TRABAJADOR</th>	
                  <th></th>					  
                </tr>
                </thead>			
              </table>
			  <div class="div-response"></div>
            </div>
			<div class="card-footer">
				<div class="row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Cantidad Registro(s)</div>
						</div>
						<input type="text" class="form-control" id="txtCantidad_permiso" value="0" readonly >
					  </div>
					</div>					
				</div>
			</div>			
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div id="modal-delete" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<p>&iquest; Desea Enviar a Administrador Permiso ?</p>
			  <div class="form-group">
				<textarea class="form-control control-text" id="txtObservacion" rows="5"></textarea>
				<small class="form-text text-muted">Observaci&oacute;nes</small>
			  </div>				
		  	  <button type="button" class="btn btn-success" id="btn-confirmar">Confirmar</button>
		  	  <button type="button" class="btn btn-danger" id="btn-anular">Anular</button>					
		  </div>
		  <div class="modal-footer">
		    <input type="hidden" class="form-control control-text" id="txtId_autoriza" value="<?php echo $_SESSION['LOGIN']['CODIGO'] ?>">
			<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  
	
	<div id="modal-confirma" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body">
			<div class="row">
				<div class="col-md-6">
                  <p>Trabajadore(s) seleccionado(s) : (<label class="lblCantidad_trabajador"></label>)</p>						
				  <table id="example2" class="table table-bordered table-striped">
					<thead>
					<tr>								
					  <th>TRABAJADOR</th>					  
					</tr>
					</thead>			
				  </table>		
				</div>
				<div class="col-md-6 text-center">
				  <p>&iquest; Desea Enviar a Administrador Permiso(s) ?</p>							
				  <div class="form-group">
					<textarea class="form-control control-text" id="txtObservacion_masiva" rows="5"></textarea>
					<small class="form-text text-muted">Observaci&oacute;nes</small>
				  </div>				
				  <button type="button" class="btn btn-success btn-sm" id="btn-confirmar-masivo">Autorizar</button>
				  <button type="button" class="btn btn-danger btn-sm" id="btn-anular-masivo">Anular</button>				  
				</div>				
			</div>			
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  	

 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../plugins/jQueryUI/jquery-ui.js"></script>

<script src="../plugins/toastr/toastr.js"></script>
<script>
  $(function () { 
  
    $(document).bind("contextmenu",function(e){
      return false;
    });	  
	  
    $('#txtObservacion').keyup(function(){
        $(this).val($(this).val().toUpperCase());
    });	 
    $('#txtObservacion_masiva').keyup(function(){
        $(this).val($(this).val().toUpperCase());
    });	 			
	
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 		  
    });
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 		  
    });	
	
	 $.datepicker.regional['es'] = {
	 closeText: 'Cerrar',
	 prevText: '< Ant',
	 nextText: 'Sig >',
	 currentText: 'Hoy',
	 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
	 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
	 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
	 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
	 weekHeader: 'Sm',
	 dateFormat: 'dd/mm/yy',
	 firstDay: 1,
	 isRTL: false,
	 showMonthAfterYear: false,
	 yearSuffix: ''
	 };
	 $.datepicker.setDefaults($.datepicker.regional['es']);
	function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }

      return date;
    }
	 
	 $("#txtFecha_inicio").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		onSelect: function(dateText, inst) {
		var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
		$('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
		}		
	 }) 
	
	 $("#txtFecha_termino").datepicker({
		dateFormat: "dd-mm-yy",
		changeMonth: true,
		changeYear: true,
		yearRange: "1900:2100",
		minDate: $("#txtFecha_inicio").val() 
	 }) 		
	
	$("#btnBuscar").click(function(){
		listarRegistro();
	});
	
	$("#txtDepartamento").change(function () {
		listarRegistro();
    });		
		
	listarRegistroDep();
	function listarRegistroDep(){

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/departamentopersona",
			data : JSON.stringify({
				id_persona:$("#txtId_autoriza").val()					
			}),			
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){						

						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id_departamento,
							text : dados[i][j].sucursal + " (" +dados[i][j].departamento +" )"
						}));
					}
				}
				listarRegistro();
			}
		});

	}		
		
	listarRegistro();
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/permisoestadodepto",	
			data : JSON.stringify({
				fecha_inicio: invertirCadena($("#txtFecha_inicio").val()),
				fecha_termino: invertirCadena($("#txtFecha_termino").val()),	
				id_departamento: $("#txtDepartamento").val(),				
				id_estado: 1									
			}),				
			success: function(dados)
			{
				var dias = ["Lun", "Mar", "Mie", "Jue", "Vie", "Sab", "Dom"];
				
				$("#txtCantidad_permiso").val(0);
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  var boton2 = "<button type='button' class='btn btn-info btn-xs btn-eliminar'>Enviar a Administrador</button>";
				
						var campo = '<div class="input-group input-group-sm">';
						campo += '<div class="input-group-prepend">';
						campo += '<span class="input-group-text">';
						campo += '<input type="checkbox" class="btn btn-checkbox">';
						campo += '</span>';
						campo += '</div>';
						campo += '</div>';				
					  
					  var fecha_inicio  = new Date(dados[i][j].fecha_inicio);
					  var fecha_termino  = new Date(dados[i][j].fecha_termino);					  
					  
					  var cantidad = dados[i][j].cantidad;
					  if(cantidad == 0) { cantidad = 1; }
					  
					  $('#example').dataTable().fnAddData( [
					    campo,
						dias[fecha_inicio.getDay()]+" "+convertDateFormat(dados[i][j].fecha_inicio),	
						dias[fecha_termino.getDay()]+" "+convertDateFormat(dados[i][j].fecha_termino),
						cantidad,						
						dados[i][j].estado,
						dados[i][j].tipo,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
					    boton2 + "<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					  $("#txtCantidad_permiso").val(parseInt($("#txtCantidad_permiso").val()) +1)
					}
				}
			}
		});

	}
	
	function convertDateFormat(string) {
        var info = string.split('-').reverse().join('-').split('-');
        return info[0]+"-"+info[1];
    }	
	
	$(".btn-checkbox-todo").click(function(){	
		if($(this).is(":checked")){
			jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
				$(this).find("td:eq(0)").find('input[type="checkbox"]').attr("checked", true);
			}); 	
		}else{
			jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
				$(this).find("td:eq(0)").find('input[type="checkbox"]').attr("checked", false);
			}); 			
		}
	});	
	
	$("#btnEnviar").click(function(){
		var contador = 0;
		jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
			if($(this).find("td:eq(0)").find('input[type="checkbox"]').is(":checked")){ contador++; }	
             $('#example2').dataTable().fnAddData( [
				$(this).find("td:eq(5)").html()
			]);			
		}); 
		if(contador > 0){
			$('#modal-confirma').modal("show");
			$(".lblCantidad_trabajador").html(contador);		 
		}				 		 				 	
	});	
	
	var idPermiso;	
	$("#example").on('click','.btn-eliminar', function() {			
		$('#modal-delete').modal("show");
	    idPermiso = $(this).parents("tr").find("td:eq(7)").find("input").val();			
	});	
		
	$("#btn-confirmar").click(function(){
		if( $("#txtObservacion").val() == null || $("#txtObservacion").val().length == 0 || /^\s+$/.test($("#txtObservacion").val()) ) {
		  toastr.warning("Debe Ingresar Observaci&oacute;n", "POWERTIME"); 
		  return false;
		}else{
			modificarEstadoPermiso(2);	
		}		
			
	});
	
	$("#btn-anular").click(function(){
		if( $("#txtObservacion").val() == null || $("#txtObservacion").val().length == 0 || /^\s+$/.test($("#txtObservacion").val()) ) {
		  toastr.warning("Debe Ingresar Observaci&oacute;n de Anulaci&oacute;n", "POWERTIME"); 
		  return false;
		}else{
			Anularpermiso(3);
		}						
	});
	
	$("#btn-confirmar-masivo").click(function(){
		if( $("#txtObservacion").val() == null || $("#txtObservacion").val().length == 0 || /^\s+$/.test($("#txtObservacion").val()) ) {
		  toastr.warning("Debe Ingresar Observaci&oacute;n de Aprobaci&oacute;n", "POWERTIME"); 
		  return false;
		}else{
			$('#modal-confirma').modal("toggle");		
			var contador = 0;
			var cantidad_trabajador = parseInt($('.lblCantidad_trabajador').html());

			jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
				if($(this).find("td:eq(0)").find('input[type="checkbox"]').is(":checked")){ 
					var idPermiso_masivo = $(this).find("td:eq(7)").find("input").val();
					/******************************************************/
					$.ajax({
						type:'POST',
						contentType: 'application/json',
						dataType: "json",
						crossDomain: true,
						headers: {
							'Content-Type': 'application/json'
						},
						url: "http://200.24.13.60/~program1/power-time-api/public/modificarestadopermiso",
						data : JSON.stringify({
							id:idPermiso_masivo,
							id_estado:2			
						}),
						success: function(data, textStatus, xhr) {
							if(parseInt(xhr.status) == 201){				
								$.ajax({
									type:'POST',
									contentType: 'application/json',
									dataType: "json",
									crossDomain: true,
									headers: {
										'Content-Type': 'application/json'
									},
									url: "http://200.24.13.60/~program1/power-time-api/public/ingresarlogpermiso",
									data : JSON.stringify({
										id_permiso:idPermiso_masivo,
										id_usuario:$("#txtId_autoriza").val(),	
										observacion:$("#txtObservacion_masiva").val()				
									}),
									success: function(data, textStatus, xhr) {
										if(parseInt(xhr.status) == 201){									
											contador++;
											if(contador == cantidad_trabajador) { 
												toastr.success("Se han Aprobado : ("+contador+") Permisos", "POWERTIME"); 
												$("#txtObservacion_masiva").val("");				
												listarRegistro();												
											}
										}
									}
								})						
								
							}
						}
					});
					/******************************************************/				
				}
			}); 			
		}			

	});		
	
	$("#btn-anular-masivo").click(function(){
		if( $("#txtObservacion").val() == null || $("#txtObservacion").val().length == 0 || /^\s+$/.test($("#txtObservacion").val()) ) {
		  toastr.warning("Debe Ingresar Observaci&oacute;n de Anulaci&oacute;n", "POWERTIME"); 
		  return false;
		}else{
			$('#modal-confirma').modal("toggle");		
			var contador = 0;
			var cantidad_trabajador = parseInt($('.lblCantidad_trabajador').html());

			jQuery($('#example').dataTable().fnGetNodes()).each(function () { 
				if($(this).find("td:eq(0)").find('input[type="checkbox"]').is(":checked")){ 
					var idPermiso_masivo = $(this).find("td:eq(7)").find("input").val();
					/******************************************************/
					$.ajax({
						type:'POST',
						contentType: 'application/json',
						dataType: "json",
						crossDomain: true,
						headers: {
							'Content-Type': 'application/json'
						},
						url: "http://200.24.13.60/~program1/power-time-api/public/modificarestadopermiso",
						data : JSON.stringify({
							id:idPermiso_masivo,
							id_estado:3			
						}),
						success: function(data, textStatus, xhr) {
							if(parseInt(xhr.status) == 201){				
								$.ajax({
									type:'POST',
									contentType: 'application/json',
									dataType: "json",
									crossDomain: true,
									headers: {
										'Content-Type': 'application/json'
									},
									url: "http://200.24.13.60/~program1/power-time-api/public/ingresarlogpermiso",
									data : JSON.stringify({
										id_permiso:idPermiso_masivo,
										id_usuario:$("#txtId_autoriza").val(),	
										observacion:$("#txtObservacion_masiva").val()				
									}),
									success: function(data, textStatus, xhr) {
										if(parseInt(xhr.status) == 201){
											contador++;
											if(contador == cantidad_trabajador) { 
												toastr.success("Se han Anulado : ("+contador+") Permisos", "POWERTIME"); 
												$("#txtObservacion_masiva").val("");				
												listarRegistro();											
											}
										}
									}
								})						
								
							}
						}
					});
					/******************************************************/				
				}
			}); 			
		}			

	});		
	
	function Anularpermiso(codigo){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/anularpermiso",
			data : JSON.stringify({
				id:idPermiso,
				id_estado:codigo,
				motivo:$("#txtObservacion").val()				
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 201){
					$('#modal-delete').modal("toggle");					
					listarRegistro();					
				}
			}
		})
	}
	
	function modificarEstadoPermiso(codigo){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/modificarestadopermiso",
			data : JSON.stringify({
				id:idPermiso,
				id_estado:codigo			
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 201){
					$('#modal-delete').modal("toggle");					
					listarRegistro();					
					$.ajax({
						type:'POST',
						contentType: 'application/json',
						dataType: "json",
						crossDomain: true,
						headers: {
							'Content-Type': 'application/json'
						},
						url: "http://200.24.13.60/~program1/power-time-api/public/ingresarlogpermiso",
						data : JSON.stringify({
							id_permiso:idPermiso,
							id_usuario:$("#txtId_autoriza").val(),	
							observacion:$("#txtObservacion").val()				
						}),
						success: function(data, textStatus, xhr) {
							if(parseInt(xhr.status) == 201){
								var mensaje = "Permiso Anulado Exitosamente";
								if(codigo == 2){ mensaje = "Permiso Aprobado Exitosamente"; }
								toastr.success(mensaje, "POWERTIME");
								$("#txtObservacion").val("");
							}
						}
					})						
					
				}
			}
		})			
	}
	
    function invertirCadena(numeros) { 
        return numeros.split('-').reverse().join('-')
    }
	

});
</script>
</body>
</html>
