<?php include_once("../lib/control.seguridad.php"); ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />  
  <style>
  #example{
	  font-size:10px;
  }
  #example2{
	  font-size:10px;
  }  

   .dataTables_wrapper { font-size: 10px }	   
   .dataTables_filter input { height: 25px }   
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Asignar Turno Usuario (Sin Turno)</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
            </div>
            <!-- /.card-header -->
            <div class="card-body">
				<div class="row">
					<div class="col-md-7">
					  <table id="example" class="table table-bordered table-striped">
						<thead>
						<tr>				
						  <th>RUT</th>				
						  <th>NOMBRE</th>	
						  <th>CARGO</th>
						  <th></th>					  
						</tr>
						</thead>			
					  </table>
					  <div class="div-response"></div>					
					</div>
					<div class="col-md-5 d-none col-turno">
					  <table id="example2" class="table table-bordered table-striped">
						<thead>
						<tr>				
						  <th>TURNO</th>
						  <th></th>					  
						</tr>
						</thead>			
					  </table>							  
					</div>
				</div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div id="modal-confirm" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME MENSAJE SISTEMA</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body">
			<p>&iquest; Desea Modificar Turno de Persona ?</p>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
			<button type="button" class="btn btn-info btn-sm" id="btn-confirmar">Confirmar</button>
		  </div>
		</div>
	  </div>
	</div>   
  
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script>
 
<script>
  $(function () { 
  
	 
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      }	 
    });
	
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "pageLength": 6,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      }	 
    });	
	
	const listarRegistro = async() =>{
    
		var formData = new FormData();
		formData.append('metodo', 'listadopersonassinturno');

		const resultado = await fetch('http://200.24.13.60/~program1/consultamarcajesmva/controller/consultascontroller.php',{
			method: "POST",
			body: formData, 
		});
		const data = await resultado.json();
		$('#example').dataTable().fnClearTable();
		const map = await data.map((res) =>{
			var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Editar</button>";	
			$('#example').dataTable().fnAddData( [				  
				res.rut,
				res.nombre +" "+res.apellido,
				res.cargo,	
				boton+ "<input type='hidden' value ='"+res.id+"' />",
			]);        

		}) 

	}
	listarRegistro();



    var idPersona;
    var parentRow;		
	$("#example").on('click','.btn-editar', function() {
		idPersona = $(this).parents("tr").find("td:eq(3)").find("input").val();
		parentRow = $(this).parents("tr");		
		$(".col-turno").removeClass("d-none");
		cargarTurno();
	});
	


    function cargarTurno(){
		$('#example2').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/turno",			
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){

                      var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Asignar</button>";						
					  $('#example2').dataTable().fnAddData( [
						dados[i][j].descripcion,	
						boton+ "<input type='hidden' value ='"+dados[i][j].id+"' />",
					  ]);
					}
				}
			}
		});		
	}
	
    var idTurno;
	$("#example2").on('click','.btn-editar', function() {
		idTurno = $(this).parents("tr").find("td:eq(1)").find("input").val();
		$('#modal-confirm').modal("show");
	});	
	
	$("#btn-confirmar").click(function(){
		$('#modal-confirm').modal("toggle");
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/ingresarturnopersona",
			data : JSON.stringify({
				id_persona:idPersona,
				id_turno:idTurno				
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 201){				
					toastr.success("Registro Ingresado Exitosamente", "POWERTIME");				
					/******************************************/
					$.ajax({
						type:'POST',
						contentType: 'application/json',
						dataType: "json",
						crossDomain: true,
						headers: {
							'Content-Type': 'application/json'
						},
						url: "http://200.24.13.60/~program1/power-time-api/public/obtenerturno",
						data : JSON.stringify({
							id:idTurno					
						}),			
						success: function(dados)
						{						
							parentRow.find("td:eq(2)").html(dados[0].descripcion);
							limpiarPantalla();							

						}
					});					
					/******************************************/
				}
			}
		})			
	});
	
	function limpiarPantalla(){
		$('#example2').dataTable().fnClearTable();
		$(".col-turno").addClass("d-none");
	}
	
});
</script>
</body>
</html>
