<?php include_once("../lib/control.seguridad.php"); ?>
<?php
    include_once('../inc/api_cred.php');
	
	$id = 0;
	$descripcion = "";	
	$modelo = "";
	$id_empresa = 0;
	$id_sucursal = 0;	
    
	if($_POST){
        
		$url = $apiUrl . '/public/obtenerreloj';
		$ch = curl_init($url); //create a new cURL resource
		$payload = json_encode(array('id' => $_POST["txtId"]));
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);//attach encoded JSON string to the POST fields
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
		$result = curl_exec($ch); //execute the POST request
        $array = json_decode($result);


		$id = $array[0]->id;
		$descripcion = $array[0]->descripcion;			
		$modelo = $array[0]->modelo;	
		$id_empresa = $array[0]->id_empresa;				
		$id_sucursal = $array[0]->id_sucursal;	
		
		curl_close($ch); 

	}
	
	$fecha_inicio = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
	$fecha_termino = date('Y-m-d', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">      
  <style>
  #example{
	  font-size:11px;
  }
  label{
	  font-size:11px;	  
  }
      .dataTables_wrapper { font-size: 10px }	    
  </style>   
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
 
  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <h4>Reloj de Marcaci&oacute;n</h4>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="container-fluid">
        <div class="row">
          <!-- left column -->
          <div class="col-md-5">
            <!-- Horizontal Form -->
            <div class="card">
				<div class="card-body">				
					  <div class="form-group input-group-sm">
						<label>Descripci&oacute;n / Nombre Reloj :</label>
						<input type="text" class="form-control control-text" id="txtDescripcion" value="<?php echo $descripcion ?>" readonly>
						<small class="form-text text-muted">Identificador del reloj.</small>
					  </div>
					  <div class="form-group input-group-sm">
						<label>Modelo :</label>
						<input type="text" class="form-control control-text" id="txtModelo" value="<?php echo $modelo ?>" readonly>
						<small class="form-text text-muted">Identificador del reloj.</small>
					  </div>					  
					  <div class="form-group input-group-sm">
						<label>Empresa :</label>
						<select class="form-control" id="txtEmpresa" disabled>
						</select>
						<small class="form-text text-muted">Seleccione Empresa a la que pertenece reloj.</small>
					  </div>
					  <div class="form-group input-group-sm">
						<label>Sucursal :</label>
						<select class="form-control" id="txtSucursal" disabled>
							<option value="0">Seleccione...</option>
						</select>
						<small class="form-text text-muted">Seleccione Sucursal a la que pertenece reloj.</small>
					  </div>						  
				</div>
				<!-- /.card-body -->
				<div class="card-footer">
				    <input type="hidden" class="form-control control-text" id="txtId" value="<?php echo $id ?>" readonly>
				</div>
            </div>
          </div>
          <div class="col-md-7">
            <!-- Horizontal Form -->
            <div class="card">
				<div class="card-header">
				  <div class="row">
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha Inicio</div>
						</div>
						<input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
					  </div>
					</div>
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Fecha Termino</div>
						</div>
						<input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
					  </div>
					</div>				
					<div class="col-md-2">
					  <button type="button" class="btn btn-info mb-2 btn-sm" id="btnBuscar">Buscar</button>				  
					</div>				
				  </div>				
				</div>
				<div class="card-body">				
				  <table id="example" class="table table-bordered table-striped">
					<thead>
					<tr>			
					  <th>FECHA</th>
					  <th>HORA</th>				  
					  <th>TRABAJADOR</th>	
					  <th>DEPARTAMENTO</th>				  
					  <th>SUCURSAL</th>						  
					</tr>
					</thead>			
				  </table>						  
				</div>
				<!-- /.card-body -->
				<div class="card-footer">
					<button type="button" class="btn btn-info btn-sm" id="btnImprimir">Imprimir Informe</button>
				</div>
            </div>
          </div>		  
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div class="modal" tabindex="-1" role="dialog"  id="modal-default">
	  <div class="modal-dialog modal-xl" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">Visor de Documentos</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body modal-body-informe">
			<iframe name="iframe3" width="100%" height="100%" src="../inc/loading.php"></iframe>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
		  </div>
		</div>
	  </div>
	</div>  	

   <div class="div-response"></div>  

 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script>

<script>

  $(function () {
	  
    $(".modal-body-informe").height(parseInt(screen.height) -400);  	
	
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });
 
	
	$(".control-text").bind('keypress', function(event) {
	  var regex = new RegExp("^[a-zA-Z 0-9]+$");
	  var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
	  if (!regex.test(key)) {
		event.preventDefault();
		return false;
	  }
	});	  
	combo();
	function combo(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/empresa",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtEmpresa').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				$('#txtEmpresa').val(<?php echo $id_empresa ?>);
				sucursal();
			}
		});				
	}
	
	function sucursal(){
		$('#txtSucursal').empty();
		$('#txtSucursal').append($('<option>', {
			value: 0,
			text : "Seleccione..."
		}));		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerempresasucursal",
			data : JSON.stringify({
				id_empresa: $('#txtEmpresa').val()				
			}),			
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtSucursal').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				$('#txtSucursal').val(<?php echo $id_sucursal ?>);
			}
		});			
	}
	
	$("#txtEmpresa").change(function () {
		sucursal();
    });		
	  
	listarRegistroMarcaje();
	function listarRegistroMarcaje(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/marcajesreloj",		
			data : JSON.stringify({
				id_reloj: $("#txtId").val(),
				fecha_inicio: $("#txtFecha_inicio").val(),	
				fecha_termino: $("#txtFecha_termino").val()					
			}),			
			success: function(dados)
			{
				$('#example').dataTable().fnClearTable();				
				
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
 				  
					  $('#example').dataTable().fnAddData( [						  
						dados[i][j].fecha,
						dados[i][j].hora,
						dados[i][j].nombre +" "+dados[i][j].apellido,						
						dados[i][j].departamento,
						dados[i][j].sucursal,					
					  ]);
					}
				}
			}
		});

	}	
	
    $("#btnImprimir").click(function(){
        $('#modal-usuario').modal("toggle");
		$('.div-response').html('<form action="exportar.pdf.inc.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'<input type="text" class="form-control" id="txtId" name="txtId" value="'+$("#txtId").val()+'" >'+	
		'<input type="text" class="form-control" id="txtFecha_inicio" name="txtFecha_inicio" value="'+$("#txtFecha_inicio").val()+'" >'+	
		'<input type="text" class="form-control" id="txtFecha_termino" name="txtFecha_termino" value="'+$("#txtFecha_termino").val()+'" >'+			
		'</form>');			
		document.forms['form'].submit();
		$('#modal-default').modal('show');				
	});
	
	$('#modal-default').on('hidden.bs.modal', function () {
		$('.div-response').empty();
		$('.div-response').html('<form action="../inc/loading.php"  target="iframe3" name="form" method="POST" style="display:none;"> '+
		'</form>');			
		document.forms['form'].submit();		 
	});	
	
});	 	
  
</script>

</body>
</html>
