<?php include_once("../lib/control.seguridad.php");?>
<?php
$fecha_inicio = date("d-m-Y"); // date('d-m-Y', mktime(0,0,0, date('m'), 1, date('Y')));
$fecha_termino = date("d-m-Y"); // date('d-m-Y', mktime(0,0,0, date('m'), date("d", mktime(0,0,0, date('m')+1, 0, date('Y'))), date('Y'))); 
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">   
  <link rel="stylesheet" href="../plugins/jQueryUI/jquery-ui.css" />  
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />   
  <style>
  #example{
	  font-size:11px;
  }
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Listado de Permisos Enviados a ACEPTA</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Listado de Permisos Enviados a ACEPTA</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="row">
                <div class="col-md-12">
                  <h3 class="card-title">Listado de Permisos Enviados a ACEPTA</h3>
                  <button type="button" class="btn btn-outline-info btn-sm float-right" id="btnExportarPDF"><i class="fas fa-file-pdf"></i> Exportar a PDF</button>
                </div>
              </div>

              <div class="row mt-4">
                <div class="col-md-3">
                  <div class="input-group mb-2 input-group-sm">
                  <div class="input-group-prepend">
                    <div class="input-group-text">Fecha Inicio</div>
                  </div>
                  <input type="text" class="form-control" id="txtFecha_inicio" value="<?php echo $fecha_inicio ?>" readonly >
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="input-group mb-2 input-group-sm">
                  <div class="input-group-prepend">
                    <div class="input-group-text">Fecha T&eacute;rmino</div>
                  </div>
                  <input type="text" class="form-control" id="txtFecha_termino" value="<?php echo $fecha_termino ?>" readonly >
                  </div>
                </div>
                <div class="col-md-2">
                  <button type="button" class="btn btn-info mb-2 btn-sm btn-block" id="btnBuscar">Buscar</button>
                </div>	                
              </div>

            </div>
            <!-- /.card-header -->
            <div class="card-body">

              <div class="row">
                <div class="col-md-12">
                  <table id="example" class="table table-bordered table-striped">
                  <thead>
                  <tr>		
                    <th>C&Oacute;DIGO ACEPTA</th>	
                    <th>N° FOLIO</th>			
                    <th>FECHA INICIO</th>	
                    <th>FECHA T&Eacute;RMINO</th>			
                    <th>RUT</th>	
                    <th>NOMBRE</th>		
                    <th>ESTADO FIRMA ELECTR&Oacute;NICA</th>	
                    <th></th>		                  					  				  						  		  
                  </tr> 
                  </thead>
                  <tbody></tbody>
                  </table>
                  <div class="div-response"></div>
                </div>
              </div>

				    </div>
			<!-- /.card-body -->
			</div>
			<!-- /.card -->
		</div>
		<!-- /.col -->
	</div>
	<!-- /.row -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include_once("../inc/footer.php"); ?>

 <!-- Modal -->
<div class="modal fade" id="modalvisor" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-file-pdf"></i> Visor de Documentos</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body modal-body-informe">
         
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i class="fas fa-backspace"></i> Cerrar</button>
      </div>
    </div>
  </div>
</div>


<!-- Modal -->
<div class="modal fade" id="modalLoading" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Mensaje de Sistema</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12 text-center">
            <img src="../img/loading.gif" style="max-width:250px;" />
          </div>
        </div>
      </div>
      <div class="modal-footer">
      <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i class="fas fa-backspace"></i> Cerrar</button>
      </div>
    </div>
  </div>
</div>

<div id="modal-delete" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<p>&iquest; Desea Anular Permiso ?</p>
			  <div class="form-group">
				<textarea class="form-control control-text" id="txtObservacion" name="txtObservacion" rows="5"></textarea>
				<small class="form-text text-muted">Observaci&oacute;nes</small>
			  </div>				
		  	  <button type="button" class="btn btn-danger" id="btn-anular">Anular</button>					
		  </div>
		  <div class="modal-footer">
		    <input type="hidden" class="form-control control-text" id="txtId_autoriza" value="<?php echo $_SESSION['LOGIN']['CODIGO'] ?>">
			<button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
		  </div>
		</div>
	  </div>
	</div>  

</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
<script src="https://unpkg.com/pdfobject@2.2.4/pdfobject.min.js"></script>
<script src="../plugins/jQueryUI/jquery-ui.js"></script>
<script src="../plugins/toastr/toastr.js"></script>

<script type="text/javascript">
    $(document).ready(function () {

      $("#txtFecha_inicio").datepicker({
        dateFormat: "dd-mm-yy",
        changeMonth: true,
        changeYear: true,
        yearRange: "1900:2100",
        onSelect: function(dateText, inst) {
        var lockDate = new Date($('#txtFecha_inicio').datepicker('getDate'));
        $('#txtFecha_termino').datepicker('option', 'minDate', lockDate);
        }		
      }) 
      
      $("#txtFecha_termino").datepicker({
        dateFormat: "dd-mm-yy",
        changeMonth: true,
        changeYear: true,
        yearRange: "1900:2100",
        minDate: $("#txtFecha_inicio").val() 
      })       

        $('#example').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": false,
            "info": true,
            "autoWidth": false,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
            } 	  
        });  

        $(".modal-body-informe").height(parseInt(screen.height) -400);  
        $("#btnExportarPDF").click(function(){
            PDFObject.embed("informepdf.php", ".modal-body-informe"); 
            $("#modalvisor").modal("show");
        });

        function invertirCadena(numeros) { 
          return numeros.split('-').reverse().join('-')
        }	

        const listado = async() =>{
    
            $("#modalLoading").modal("show");
            var formData = new FormData();
            formData.append('fechainicio', invertirCadena($("#txtFecha_inicio").val()));
            formData.append('fechatermino', invertirCadena($("#txtFecha_termino").val()));

            const resultado = await fetch('sincronizacion.php',{
                method: "POST",
                body: formData, 
            });
            const data = await resultado.json();
            $('#example').dataTable().fnClearTable();

            let personasMap = data.map(persona => {
                return [JSON.stringify(persona), persona]
            });
            let personasMapArr = new Map(personasMap); // Pares de clave y valor

            let unicos = [...personasMapArr.values()]; // Conversión a un array            

            const map = await unicos.map((res) =>{
                $('#example').dataTable().fnAddData( [ 
                    res.pdfacepta,
                    res.idpermiso,
                    convertDateFormat(res.fechainicio),
                    convertDateFormat(res.fechatermino),
                    res.rut,
                    res.nombre,
                    res.estado,
                    "<button type='button' class='btn btn-danger btn-xs btn-eliminar'>Anular</button>"
                ]);        

            }) 

            $("#modalLoading").modal("toggle");

        }
        listado();

        function convertDateFormat(string) {
            var info = string.split('-').reverse().join('-').split('-');
            return info[0]+"-"+info[1]+"-"+info[2];
        }	        

        $("#btnBuscar").click(function(){
          listado();
        });

        var idPermiso;	
        $("#example").on('click','.btn-eliminar', function() {			
            $('#modal-delete').modal("show");
            idPermiso = $(this).parents("tr").find("td:eq(1)").html();

        });	
		        
        $("#btn-anular").click(function(){
		
		if( $("#txtObservacion").val() == null || $("#txtObservacion").val().length == 0 || /^\s+$/.test($("#txtObservacion").val()) ) {
		  toastr.warning("Debe ingresar Observaci&oacute;n de Anulado", "POWERTIME");
		  return false;
		}else{
			modificarEstadoPermiso(3);
		}		
			
	});

	function modificarEstadoPermiso(codigo){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/anularpermiso",
			data : JSON.stringify({
				id:idPermiso,
				id_estado:codigo,
				motivo:$("#txtObservacion").val()				
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 201){
					$('#modal-delete').modal("toggle");		
 
					toastr.success("Permiso Anulado", "POWERTIME");			
					listado();					
				}
			}
		})			
	}	
    
    });    
</script>