<?php
require('../librerias/PHPExcel/Classes/PHPExcel.php');
$objPHPExcel = new PHPExcel();

$objPHPExcel->
getProperties()
->setCreator("POWERTIME")
->setLastModifiedBy("POWERTIME")
->setTitle("Reporte POWERTIME")
->setSubject("Resumen POWERTIME")
->setDescription("Documento generado POWERTIME, Reporte registros base de datos")
->setKeywords("Reportes POWERTIME")
->setCategory("Reportes");

$fecha_inicio = $_POST["txtFecha_inicio"];
$fecha_termino = $_POST["txtFecha_termino"];
$id_departamento = $_POST["txtDepartamento"];
$id_estado = $_POST["txtEstado"];

$url = 'http://200.24.13.60/~program1/power-time-api/public/permisoestadoacepta';
$ch = curl_init($url); //create a new cURL resource
$payload = json_encode(array('id_departamento' => $id_departamento, 'fecha_inicio' => $fecha_inicio, 'fecha_termino' => $fecha_termino, 'id_estado' => $id_estado));
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);//attach encoded JSON string to the POST fields
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //set the content type to application/json
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //return response instead of outputting
$result = curl_exec($ch); //execute the POST request
$array = json_decode($result);

$objPHPExcel->setActiveSheetIndex(0)
->setCellValue('A1', 'FOLIO')
->setCellValue('B1', 'CODIGO ACEPTA')
->setCellValue('C1', 'AREA')
->setCellValue('D1', 'CENTRO')
->setCellValue('E1', 'FECHA INICIO')
->setCellValue('F1', 'FECHA TERMINO')
->setCellValue('G1', 'CANTIDAD DIAS')
->setCellValue('H1', 'ESTADO DE PERMISO')
->setCellValue('I1', 'TIPO DE PERMISO')
->setCellValue('J1', 'RUT')
->setCellValue('K1', 'TRABAJADOR');

$fila = 2;

// utf8_decode($row->estado)

foreach ($array[0] as $row) {
 
	$objPHPExcel->setActiveSheetIndex(0)
	->setCellValue('A'. $fila, $row->id)
	->setCellValue('B'. $fila, $row->pdfacepta)
	->setCellValue('C'. $fila, eliminar_acentos($row->sucursal))
	->setCellValue('D'. $fila, eliminar_acentos($row->departamento))
	->setCellValue('E'. $fila, date("d/m/Y", strtotime($row->fecha_inicio)))
	->setCellValue('F'. $fila, date("d/m/Y", strtotime($row->fecha_termino)))
	->setCellValue('G'. $fila, $row->cantidad)
	->setCellValue('H'. $fila, $row->estado)
	->setCellValue('I'. $fila, eliminar_acentos($row->tipo))	
	->setCellValue('J'. $fila, $row->rut)	
	->setCellValue('K'. $fila, eliminar_acentos($row->nombre) ." ". eliminar_acentos($row->apellido) );	
  
	$fila++;	
}

	
function eliminar_acentos($cadena){
		
		//Reemplazamos la A y a
		$cadena = str_replace(
		array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
		array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
		$cadena
		);
 
		//Reemplazamos la E y e
		$cadena = str_replace(
		array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
		array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
		$cadena );
 
		//Reemplazamos la I y i
		$cadena = str_replace(
		array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
		array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
		$cadena );
 
		//Reemplazamos la O y o
		$cadena = str_replace(
		array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
		array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
		$cadena );
 
		//Reemplazamos la U y u
		$cadena = str_replace(
		array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
		array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
		$cadena );
 
		//Reemplazamos la N, n, C y c
		$cadena = str_replace(
		array('Ñ', 'ñ', 'Ç', 'ç'),
		array('N', 'n', 'C', 'c'),
		$cadena
		);
		
		return $cadena;
	}

$objPHPExcel->getActiveSheet()->setTitle('Listado General');
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="nombreFichero.xlsx"');
header('Cache-Control: max-age=0');

$objWriter=PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');
$objWriter->save('php://output');
exit;


?>
