<?php include_once("../lib/control.seguridad.php"); ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>POWERTIME</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.css">    
 
  <link href="../plugins/toastr/build/toastr.css" rel="stylesheet" type="text/css" />  
   <style>
	  #example{
		  font-size:10px;
	  }
	  .content-header h4{ 
		  font-size: 20px
	  }
     .dataTables_wrapper { font-size: 10px; }	
	.dataTables_filter input { height: 25px; }	   
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include_once("../inc/header.php"); ?>

  <?php include_once("../inc/menu.php"); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <h4>Usuarios Activos</h4>
          </div>
          <div class="col-sm-6">
            <button type="button" class="btn btn-info float-right btn-sm" style="margin-left:10px;" id="btnNuevo_registro">Nuevo Registro</button>
			<a href="excelusuarios.php" class="btn btn-info float-right btn-sm" style="margin-left:10px;" id="btnGenerarExcel">Generar Listado Excel</a>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content" id="app">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
			
				<div class="form-row">
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">&Aacute;rea</div>
						</div>
						<select class="form-control" id="txtSucursal"> </select>
					  </div>
					</div>	
					<div class="col-md-3">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Centro</div>
						</div>
						<select class="form-control" id="txtDepartamento">
							<option value="0">Todos...</option>
						</select>
					  </div>
					</div>	
					<div class="col-md-4">
					  <div class="input-group mb-2 input-group-sm">
						<div class="input-group-prepend">
						  <div class="input-group-text">Nombre / Rut</div>
						</div>
						<input type="text" class="form-control" id="txtRut" value="">
					  </div>
					</div>		
					<div class="col-md-2">
					    <button type='button' class='btn btn-info btn-sm btn-block' id='btnEnviar' name='btnEnviar'>Filtrar</button>
					</div>						
				</div>	
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                <tr>			
                  <th>RUT</th>				
                  <th>NOMBRE</th>	
                  <th>TURNO</th>
                  <th>CARGO</th>	
                  <th>CENTRO</th>					  
                  <th></th>					  
                </tr>
                </thead>			
              </table>
			  <div class="div-response"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include_once("../inc/footer.php"); ?>
  
	<div id="modal-delete" class="modal" tabindex="-1" role="dialog">
	  <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header">
			<h5 class="modal-title">POWERTIME</h5>
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
			  <span aria-hidden="true">&times;</span>
			</button>
		  </div>
		  <div class="modal-body text-center">
			<p>&iquest; Desea Desactivar Cuenta de Usuario ? <br /> Una vez desactivada la cuenta solo podr&aacute; consultar informaci&oacute;n relacionada a usuario(a)</p>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
			<button type="button" class="btn btn-info" id="btn-confirmar">Confirmar</button>
		  </div>
		</div>
	  </div>
	</div>  

 
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.min.js"></script>
<!-- DataTables -->
<script src="../plugins/datatables/jquery.dataTables.js"></script>
<script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>

<script src="../plugins/toastr/toastr.js"></script> 
 
<script>
  $(function () { 
    $('#example').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
	  "language": {
		"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"
      } 	  
    });
	
	combo();
	function combo(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/sucursal",		
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtSucursal').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				departamento();
			}
		});				
	}

	$("#txtSucursal").change(function () {
		departamento();
    });

	function departamento(){
		$('#txtDepartamento').empty();	
		$('#txtDepartamento').append($('<option>', {
			value: 0,
			text : "Todos.."
		}));		
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerdepartamentosucursal",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),								
			}),			
			success: function(dados)
			{
				for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						$('#txtDepartamento').append($('<option>', {
							value: dados[i][j].id,
							text : dados[i][j].descripcion
						}));
					}
				}
				listarRegistro();
			}
		});			
	}	
	
	$("#txtDepartamento").change(function () {
		listarRegistro();
    });
	
	$("#txtRut").keyup(function(e){
		if(e.keyCode == 13){
			buscarPersona();
		}
	});		
    
    $("#btnEnviar").click(function(){
        buscarPersona();
    }); 

	function buscarPersona(){
		$('#example').dataTable().fnClearTable();
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/buscarpersona",
			data : JSON.stringify({
				descripcion: $("#txtRut").val()			
			}),			
			success: function(dados)
			{
			    //console.log(dados);
				$('#example').dataTable().fnClearTable();
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Editar</button>";
					  var boton2 = "<button type='button' class='btn btn-info btn-xs btn-eliminar'>Desactivar Cuenta</button>";
					  var boton3 = "<button type='button' class='btn btn-info btn-xs btn-configuracion'>Configurar Permiso</button>";
					  var boton4 = "<button type='button' class='btn btn-info btn-xs btn-ver-ficha'>Ver Ficha</button>";
					  $('#example').dataTable().fnAddData( [
						dados[i][j].rut,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].turno,	
						dados[i][j].cargo,
						dados[i][j].departamento,						
						boton +" "+boton2+" "+boton4+" "+boton3 + "<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					}
				}
			}
		});			
	}
    
	function listarRegistro(){

		$('#example').dataTable().fnClearTable();

		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
            crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "<?php include_once('../inc/api_cred.php'); echo $apiUrl; ?>/public/obtenerpersonadepartamentosucursal",
			data : JSON.stringify({
				id_sucursal: $('#txtSucursal').val(),				
				id_departamento: $('#txtDepartamento').val(),								
			}),		
			success: function(dados)
			{
				 for (i=0;i<dados.length;i++){
					for (j=0;j<dados[i].length;j++){
						
					  var boton = "<button type='button' class='btn btn-info btn-xs btn-editar'>Editar</button>";
					  var boton2 = "<button type='button' class='btn btn-info btn-xs btn-eliminar'>Desactivar Cuenta</button>";
					  var boton3 = "<button type='button' class='btn btn-info btn-xs btn-configuracion'>Configurar Permiso</button>";
					  var boton4 = "<button type='button' class='btn btn-info btn-xs btn-ver-ficha'>Ver Ficha</button>";
					  $('#example').dataTable().fnAddData( [
						dados[i][j].rut,	
						dados[i][j].nombre+" "+dados[i][j].apellido,
						dados[i][j].turno,	
						dados[i][j].cargo,
						dados[i][j].departamento,						
						boton +" "+boton2+" "+boton4+" "+boton3 + "<input type='hidden' value ='"+dados[i][j].id+"' />"
					  ]);
					}
				}
			}
		});

	}
	
	$("#example").on('click','.btn-ver-ficha', function() {
		var id = $(this).parents("tr").find("td:eq(5)").find("input").val();
		$('.div-response').html('<form action="../usuariodepartamento/index.php" name="form" method="post" style="display:none;"><input type="text" name="txtId" id="txtId" value="'+ id +'" /></form>');
		document.forms['form'].submit();
	});		
	
	$("#example").on('click','.btn-editar', function() {
		var id = $(this).parents("tr").find("td:eq(5)").find("input").val();
		$('.div-response').html('<form action="index.php" name="form" method="post" style="display:none;"><input type="text" name="txtId" id="txtId" value="'+ id +'" /></form>');
		document.forms['form'].submit();
	});	
	
	$("#example").on('click','.btn-configuracion', function() {
		var id = $(this).parents("tr").find("td:eq(5)").find("input").val();
		$('.div-response').html('<form action="../configuracionpermiso/index.php" name="form" method="post" style="display:none;"><input type="text" name="txtId" id="txtId" value="'+ id +'" /></form>');
		document.forms['form'].submit();
	});	
				
	
	var idEliminar;	
	$("#example").on('click','.btn-eliminar', function() {			
		$('#modal-delete').modal("show");
	    idEliminar = $(this).parents("tr").find("td:eq(5)").find("input").val();
	});	
		
	$("#btn-confirmar").click(function(){
		$.ajax({
			type:'POST',
			contentType: 'application/json',
			dataType: "json",
			crossDomain: true,
			headers: {
				'Content-Type': 'application/json'
			},
			url: "http://200.24.13.60/~program1/power-time-api/public/eliminarpersona",
			data : JSON.stringify({
				id:idEliminar		
			}),
			success: function(data, textStatus, xhr) {
				if(parseInt(xhr.status) == 201){
					$('#modal-delete').modal("toggle");					
                     toastr.success("Usuario Desactivado Exitosamente", "POWERTIME");
					listarRegistro();
				}
			}
		})		
	});
	
	
	$("#btnNuevo_registro").click(function(){
		window.location="index.php";
	});		
});
</script>
</body>
</html>
